/*
 * Decompiled with CFR 0.152.
 */
package com.github.cosycode.ext.dataformat;

import com.github.cosycode.common.lang.BaseRuntimeException;
import com.github.cosycode.ext.dataformat.BeanUtils;
import com.github.cosycode.ext.dataformat.TypeConverter;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.opencsv.CSVReader;
import com.opencsv.CSVWriter;
import com.opencsv.exceptions.CsvException;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;

public class CsvUtils {
    private CsvUtils() {
    }

    public static List<String[]> readCSV(File csvFile) throws IOException, CsvException {
        DataInputStream dataInputStream = new DataInputStream(Files.newInputStream(csvFile.toPath(), new OpenOption[0]));
        try (CSVReader csvReader = new CSVReader((Reader)new InputStreamReader((InputStream)dataInputStream, StandardCharsets.UTF_8));){
            List list = csvReader.readAll();
            return list;
        }
    }

    public static <T> List<T> readCsvToBeanList(File csvFile, Class<T> tClass) throws IOException, CsvException, InstantiationException, IllegalAccessException, ParseException {
        String[] headerString;
        List<String[]> strings = CsvUtils.readCSV(csvFile);
        if (strings == null) {
            return new ArrayList();
        }
        Field[] fields = tClass.getDeclaredFields();
        Function<String, Field> function = name -> {
            for (Field field : fields) {
                if (!field.getName().equalsIgnoreCase((String)name)) continue;
                return field;
            }
            return null;
        };
        ArrayList<Field> list = new ArrayList<Field>();
        for (String str : headerString = strings.get(0)) {
            Field apply = function.apply(str = str.trim());
            if (apply == null) continue;
            apply.setAccessible(true);
            list.add(apply);
        }
        Field[] header = list.toArray(new Field[0]);
        ArrayList<T> result = new ArrayList<T>();
        int len = header.length;
        int rowLen = strings.size();
        for (int rowNum = 1; rowNum < rowLen; ++rowNum) {
            Object[] data = strings.get(rowNum);
            T t = tClass.newInstance();
            for (int i = 0; i < len; ++i) {
                Field field = header[i];
                if (field == null) continue;
                String da = data[i] == null ? "" : data[i].trim();
                Class<?> type = field.getType();
                try {
                    if (da.isEmpty()) continue;
                    Object obj = TypeConverter.convertStringToObj(da, type);
                    field.set(t, obj);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new BaseRuntimeException("convertStringToObj error, data is " + Arrays.toString(data), (Throwable)e);
                }
            }
            result.add(t);
        }
        return result;
    }

    public static <T> void writeBeanListToCsvFile(File file, @NonNull List<T> list, Class<? super T> tClass) throws IOException {
        if (list == null) {
            throw new NullPointerException("list is marked non-null but is null");
        }
        if (list.isEmpty()) {
            return;
        }
        FileWriter writer = new FileWriter(file);
        try (CSVWriter csvWriter = new CSVWriter((Writer)writer);){
            String[] fieldString = BeanUtils.getFieldString(tClass);
            csvWriter.writeNext(fieldString);
            for (T obj : list) {
                String[] strings = BeanUtils.getStringValueObj(tClass, obj);
                csvWriter.writeNext(strings);
            }
        }
    }

    public static Map<String, Object> convertMap(String[] keys, String[] values) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        for (int i = 0; i < keys.length; ++i) {
            json.put(keys[i], values[i]);
        }
        return json;
    }

    public static List<Map<String, Object>> convertMap(String[] keys, List<String[]> stringsList) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (String[] strings : stringsList) {
            Map<String, Object> json = CsvUtils.convertMap(keys, strings);
            mapList.add(json);
        }
        return mapList;
    }

    public static void jsonToCsv(String json, String csvFile) throws IOException {
        List objectList = (List)new Gson().fromJson(json, new TypeToken<List<JsonObject>>(){}.getType());
        HashSet keySet = new HashSet();
        List collect = objectList.stream().map(it -> {
            HashMap<String, String> map = new HashMap<String, String>();
            CsvUtils.flatBean(map, it, "");
            keySet.addAll(map.keySet());
            return map;
        }).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return;
        }
        String[] fieldString = keySet.toArray(new String[0]);
        FileWriter writer = new FileWriter(csvFile);
        try (CSVWriter csvWriter = new CSVWriter((Writer)writer);){
            csvWriter.writeNext(fieldString);
            for (Map flatMap : collect) {
                String[] strings = new String[fieldString.length];
                for (int i = 0; i < fieldString.length; ++i) {
                    String value;
                    String key = fieldString[i];
                    strings[i] = value = (String)flatMap.get(key);
                }
                csvWriter.writeNext(strings);
            }
        }
    }

    public static void flatBean(Map<String, String> map, JsonObject object, String prefixKey) {
        Set keySet = object.keySet();
        for (String key : keySet) {
            key = prefixKey + key;
            JsonElement jsonElement = object.get(key);
            if (jsonElement.isJsonPrimitive()) {
                map.put(key, jsonElement.getAsJsonPrimitive().toString());
                continue;
            }
            if (jsonElement.isJsonNull()) {
                map.put(key, null);
                continue;
            }
            if (jsonElement.isJsonObject()) {
                JsonObject subObject = jsonElement.getAsJsonObject();
                CsvUtils.flatBean(map, subObject, key + ".");
                continue;
            }
            if (!jsonElement.isJsonArray()) continue;
            map.put(key, jsonElement.toString());
        }
    }
}

