/*
 * Decompiled with CFR 0.152.
 */
package com.github.cosycode.ext.dataformat;

import com.google.gson.Gson;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;

public class TypeConverter {
    private TypeConverter() {
    }

    public static String convertObjToString(Object obj) {
        if (obj == null) {
            return null;
        }
        Class<?> type = obj.getClass();
        if (type.equals(String.class)) {
            return (String)obj;
        }
        if (type.equals(Boolean.class) || type.equals(Integer.class)) {
            return obj.toString();
        }
        return new Gson().toJson(obj);
    }

    public static <T> T convertStringToObj(String string, Class<T> type) throws ParseException {
        if (type.equals(String.class)) {
            return (T)string;
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return (T)Boolean.valueOf(Boolean.parseBoolean(string));
        }
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            return (T)Integer.valueOf(Integer.parseInt(string));
        }
        if (type.equals(Date.class)) {
            return (T)DateUtils.parseDate((String)string, (String[])new String[0]);
        }
        if (type.equals(BigDecimal.class)) {
            return (T)new BigDecimal(string);
        }
        return (T)new Gson().fromJson(string, type);
    }
}

