/*
 * Decompiled with CFR 0.152.
 */
package com.github.cosycode.ext.fileimport.base;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class FieldMapping<T> {
    private final String fieldName;
    private final Class<T> type;
    private final boolean require;
    private final String ruleRegex;
    private final Object defaultObj;
    private final String[] codeArr;
    private final String[] textArr;
    private final String separator;
    private final Function<Object, ?> function;
    private Pattern pattern;

    public FieldMapping(@NonNull String fieldName, @NonNull Class<T> type, boolean require, String ruleRegex, Object defaultObj) {
        this(fieldName, type, require, ruleRegex, defaultObj, null, null, null, null);
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
    }

    public FieldMapping(@NonNull String fieldName, @NonNull Class<T> type, boolean require, String[] codeArr, String[] textArr) {
        this(fieldName, type, require, null, null, codeArr, textArr, null, null);
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
    }

    public FieldMapping(@NonNull String fieldName, @NonNull Class<T> type, boolean require, String[] codeArr, String[] textArr, String multipleSeparator) {
        this(fieldName, type, require, null, null, codeArr, textArr, multipleSeparator, null);
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
    }

    public FieldMapping(@NonNull String fieldName, @NonNull Class<T> type, boolean require, Function<Object, ?> function) {
        this(fieldName, type, require, null, null, null, null, null, function);
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
    }

    private FieldMapping(String fieldName, Class<T> type, boolean require, String ruleRegex, Object defaultObj, String[] codeArr, String[] textArr, String separator, Function<Object, ?> function) {
        this.fieldName = fieldName;
        this.type = type;
        this.require = require;
        this.ruleRegex = ruleRegex;
        this.defaultObj = defaultObj;
        this.codeArr = codeArr;
        this.textArr = textArr;
        this.separator = separator;
        this.function = function;
    }

    private boolean checkRegex(String value) {
        if (this.ruleRegex == null) {
            return true;
        }
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.ruleRegex);
        }
        return this.pattern.matcher(value).matches();
    }

    public Object resolveValue(Object value) throws ParseException {
        if (this.function != null) {
            return this.function.apply(value);
        }
        if (value instanceof String) {
            String strVal = ((String)value).trim();
            if (this.codeArr != null) {
                if (StringUtils.isNotBlank((CharSequence)this.separator)) {
                    String[] strings = strVal.split(this.separator);
                    ArrayList<String> valueList = new ArrayList<String>(strings.length);
                    for (String it : strings) {
                        if ((it = it.trim()).isEmpty()) continue;
                        valueList.add(this.getDbSaveValue(it));
                    }
                    return StringUtils.join(valueList, (String)this.separator);
                }
                return this.getDbSaveValue(strVal);
            }
            if (this.pattern != null && !this.checkRegex(strVal)) {
                throw new ParseException("Data rule validation failed", 0);
            }
            return strVal;
        }
        return value;
    }

    private String getDbSaveValue(String value) throws ParseException {
        if (this.textArr != null) {
            int len = this.textArr.length;
            for (int i = 0; i < len; ++i) {
                if (!this.textArr[i].endsWith(value)) continue;
                return this.codeArr[i];
            }
        }
        if (Arrays.asList(this.codeArr).contains(value)) {
            return value;
        }
        throw new ParseException("No matching data dictionary entry found", 0);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Class<T> getType() {
        return this.type;
    }

    public boolean isRequire() {
        return this.require;
    }

    public String getRuleRegex() {
        return this.ruleRegex;
    }

    public Object getDefaultObj() {
        return this.defaultObj;
    }
}

