/*
 * Decompiled with CFR 0.152.
 */
package com.github.cosycode.ext.hub;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public abstract class AbstractClosureProxy<T, P, R> {
    protected final T functional;
    protected final BiFunction<T, P, R> biFunction;

    protected AbstractClosureProxy(T functional) {
        this.functional = functional;
        this.biFunction = this.geneDefaultBiFunction();
    }

    protected AbstractClosureProxy(T functional, BiConsumer<T, P> biConsumer) {
        this(functional, (T t, P p) -> {
            biConsumer.accept(t, p);
            return null;
        });
    }

    protected AbstractClosureProxy(T functional, BiFunction<T, P, R> biFunction) {
        Objects.requireNonNull(functional, "functional cannot be null");
        this.functional = functional;
        this.biFunction = biFunction == null ? this.geneDefaultBiFunction() : biFunction;
    }

    public abstract R closureFunction(P var1);

    public void closureConsumer(P params) {
        this.closureFunction(params);
    }

    public R closureSupplier() {
        return this.closureFunction(null);
    }

    public void closureRunnable() {
        this.closureFunction(null);
    }

    public P closureUnaryOperator(P params) {
        return (P)this.closureFunction(params);
    }

    public T proxy() {
        if (this.functional instanceof Consumer) {
            Consumer<Object> proxy = this::closureConsumer;
            return (T)proxy;
        }
        if (this.functional instanceof UnaryOperator) {
            UnaryOperator proxy = this::closureUnaryOperator;
            return (T)proxy;
        }
        if (this.functional instanceof Function) {
            Function<Object, Object> proxy = this::closureFunction;
            return (T)proxy;
        }
        if (this.functional instanceof Supplier) {
            Supplier<Object> proxy = this::closureSupplier;
            return (T)proxy;
        }
        if (this.functional instanceof Runnable) {
            Runnable proxy = this::closureRunnable;
            return (T)proxy;
        }
        throw new IllegalArgumentException("the parameter functional" + this.functional + " must be a supported functional interface");
    }

    public <V> V proxy(Function<Function<P, R>, V> function) {
        return function.apply(this::closureFunction);
    }

    private BiFunction<T, P, R> geneDefaultBiFunction() {
        if (this.functional instanceof Consumer) {
            return (t, p) -> {
                Consumer consumer = (Consumer)t;
                consumer.accept(p);
                return null;
            };
        }
        if (this.functional instanceof UnaryOperator) {
            return (t, p) -> {
                UnaryOperator consumer = (UnaryOperator)t;
                return consumer.apply(p);
            };
        }
        if (this.functional instanceof Function) {
            return (t, p) -> {
                Function consumer = (Function)t;
                return consumer.apply(p);
            };
        }
        if (this.functional instanceof Supplier) {
            return (t, p) -> {
                Supplier supplier = (Supplier)t;
                return supplier.get();
            };
        }
        if (this.functional instanceof Runnable) {
            return (t, p) -> {
                ((Runnable)t).run();
                return null;
            };
        }
        throw new IllegalArgumentException("the parameter functional" + this.functional + " must be a supported functional interface");
    }
}

