/*
 * Decompiled with CFR 0.152.
 */
package com.github.cosycode.ext.hub;

import com.github.cosycode.ext.hub.AbstractClosureProxy;
import java.util.concurrent.Semaphore;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentLimitClosureProxy<T, P, R>
extends AbstractClosureProxy<T, P, R> {
    private static final Logger log = LoggerFactory.getLogger(CurrentLimitClosureProxy.class);
    private final Semaphore semaphore;

    public CurrentLimitClosureProxy(int limit, @NonNull T then) {
        super(then);
        if (then == null) {
            throw new NullPointerException("then is marked non-null but is null");
        }
        this.check(limit);
        this.semaphore = new Semaphore(limit);
    }

    public CurrentLimitClosureProxy(int limit, @NonNull T then, @NonNull BiFunction<T, P, R> function) {
        super(then, function);
        if (then == null) {
            throw new NullPointerException("then is marked non-null but is null");
        }
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        this.check(limit);
        this.semaphore = new Semaphore(limit);
    }

    public CurrentLimitClosureProxy(int limit, @NonNull T then, @NonNull BiConsumer<T, P> biConsumer) {
        super(then, biConsumer);
        if (then == null) {
            throw new NullPointerException("then is marked non-null but is null");
        }
        if (biConsumer == null) {
            throw new NullPointerException("biConsumer is marked non-null but is null");
        }
        this.check(limit);
        this.semaphore = new Semaphore(limit);
    }

    private void check(int limit) {
        if (limit <= 0) {
            throw new IllegalArgumentException("limit cannot less than 1");
        }
    }

    @Override
    public R closureFunction(P params) {
        try {
            this.semaphore.acquire();
            this.biFunction.apply(this.functional, params);
        }
        catch (InterruptedException e) {
            log.error("Failed to get signal, params: " + params, (Throwable)e);
            Thread.currentThread().interrupt();
        }
        finally {
            this.semaphore.release();
        }
        return null;
    }
}

