/*
 * Decompiled with CFR 0.152.
 */
package com.github.cosycode.ext.io.cache;

import com.github.cosycode.common.base.SupplierWithThrow;
import com.github.cosycode.ext.io.cache.AbstractMapCacheHandler;
import java.io.IOException;
import java.util.function.Predicate;
import lombok.NonNull;

public abstract class AbstractKeyCacheHandler<P, R> {
    AbstractMapCacheHandler<R> mapCacheHandler;

    public R computeIfAbsent(P p, @NonNull SupplierWithThrow<R, IOException> supplier, Predicate<R> validate) throws IOException {
        Object response;
        if (supplier == null) {
            throw new NullPointerException("supplier is marked non-null but is null");
        }
        String requestKey = "";
        boolean useCache = this.filter(p);
        if (useCache && (response = this.get(requestKey = this.computeKey(p))) != null) {
            return (R)response;
        }
        response = supplier.get();
        if (useCache && (validate == null || validate.test(response))) {
            this.put(requestKey, response);
        }
        return (R)response;
    }

    public abstract boolean filter(P var1);

    public abstract String computeKey(P var1);

    public R get(String key) {
        return this.mapCacheHandler.get(key);
    }

    public void put(String requestKey, R myHttpResponse) {
        this.mapCacheHandler.put(requestKey, myHttpResponse);
    }

    public AbstractKeyCacheHandler(AbstractMapCacheHandler<R> mapCacheHandler) {
        this.mapCacheHandler = mapCacheHandler;
    }
}

