/*
 * Decompiled with CFR 0.152.
 */
package com.github.cosycode.ext.io.cache;

import com.github.cosycode.common.base.RunnableWithThrow;
import com.github.cosycode.common.base.SupplierWithThrow;
import com.github.cosycode.common.ext.hub.Throws;
import com.github.cosycode.common.lang.BaseRuntimeException;
import com.github.cosycode.common.util.io.FileSystemUtils;
import com.github.cosycode.common.util.io.IoUtils;
import com.github.cosycode.common.util.io.PropsUtil;
import com.github.cosycode.ext.se.util.JsonUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import lombok.NonNull;

public abstract class AbstractMapCacheHandler<T> {
    private String tag;

    public abstract void put(String var1, T var2);

    public abstract T get(String var1);

    public boolean validate(String key, T t) {
        return true;
    }

    public void clear(String key) {
        this.put(key, null);
    }

    public static <T> AbstractMapCacheHandler<T> geneMemoryCacheHandler(String tag) {
        return new AbstractMapCacheHandler<T>(tag){
            T value;

            @Override
            public void put(String key, T value) {
                this.value = value;
            }

            @Override
            public T get(String key) {
                return this.value;
            }
        };
    }

    public static <T> AbstractMapCacheHandler<T> genePropertiesCacheHandler(String tag, final @NonNull String filePath, final Class<T> tClass) {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        return new AbstractMapCacheHandler<T>(tag + " => " + filePath){
            private final File file;
            private Properties properties;
            {
                super(tag);
                try {
                    this.file = new File(filePath);
                    this.properties = this.file.exists() ? PropsUtil.loadProps((String)filePath) : new Properties();
                }
                catch (IOException e) {
                    throw new BaseRuntimeException("", (Throwable)e);
                }
            }

            @Override
            public void put(String key, T value) {
                FileSystemUtils.insureFileExist((File)this.file);
                this.properties.put(key, JsonUtils.toJson(value));
                try (FileOutputStream outputStream = new FileOutputStream(this.file);){
                    this.properties.store(outputStream, "put key: " + key);
                }
                catch (IOException e) {
                    throw new BaseRuntimeException("", (Throwable)e);
                }
            }

            @Override
            public T get(String key) {
                Object o = this.properties.get(key);
                if (o == null) {
                    return null;
                }
                String response = o.toString();
                return JsonUtils.fromJson(response, tClass);
            }

            @Override
            public void clear(String key) {
                this.properties = new Properties();
                this.file.deleteOnExit();
            }
        };
    }

    public static <T> AbstractMapCacheHandler<T> geneFileCacheHandler(String tag, final @NonNull String fileDir, final Class<T> tClass) {
        if (fileDir == null) {
            throw new NullPointerException("fileDir is marked non-null but is null");
        }
        return new AbstractMapCacheHandler<T>(tag + " => " + fileDir){

            private String getFilePath(String key) {
                return fileDir + key;
            }

            @Override
            public void put(String key, T value) {
                File file = new File(this.getFilePath(key));
                FileSystemUtils.insureFileExist((File)file);
                Throws.runtimeEpt((RunnableWithThrow & Serializable)() -> IoUtils.writeFile((String)file.getPath(), (byte[])JsonUtils.toJson(value).getBytes(StandardCharsets.UTF_8)));
            }

            @Override
            public T get(String key) {
                File file = new File(this.getFilePath(key));
                if (file.exists()) {
                    String response = (String)Throws.runtimeEpt((SupplierWithThrow & Serializable)() -> IoUtils.readFile((File)file));
                    return JsonUtils.fromJson(response, tClass);
                }
                return null;
            }

            @Override
            public void clear(String key) {
                File file = new File(this.getFilePath(key));
                file.deleteOnExit();
            }
        };
    }

    public AbstractMapCacheHandler(String tag) {
        this.tag = tag;
    }

    public String getTag() {
        return this.tag;
    }
}

