/*
 * Decompiled with CFR 0.152.
 */
package com.github.cosycode.ext.io.cache;

import com.github.cosycode.common.lang.BaseRuntimeException;
import com.github.cosycode.ext.io.cache.AbstractMapCacheHandler;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapCacheChain<T> {
    private static final Logger log = LoggerFactory.getLogger(MapCacheChain.class);
    final List<AbstractMapCacheHandler<T>> cacheHandlerList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getData(String key) {
        Objects.requireNonNull(this.cacheHandlerList);
        if (this.cacheHandlerList.isEmpty()) {
            throw new BaseRuntimeException("cacheHandlerList is empty", new Object[0]);
        }
        AbstractMapCacheHandler<T> firstHandler = this.cacheHandlerList.get(0);
        T t = firstHandler.get(key);
        if (t == null || !firstHandler.validate(key, t)) {
            List<AbstractMapCacheHandler<T>> list = this.cacheHandlerList;
            synchronized (list) {
                t = firstHandler.get(key);
                if (t == null || !firstHandler.validate(key, t)) {
                    Iterator<AbstractMapCacheHandler<T>> iterator = this.cacheHandlerList.iterator();
                    return this.getData(key, iterator, null);
                }
            }
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getData(String key, Supplier<T> supplier) {
        Objects.requireNonNull(this.cacheHandlerList);
        if (this.cacheHandlerList.isEmpty()) {
            throw new BaseRuntimeException("cacheHandlerList is empty", new Object[0]);
        }
        AbstractMapCacheHandler<T> firstHandler = this.cacheHandlerList.get(0);
        T t = firstHandler.get(key);
        if (t == null || !firstHandler.validate(key, t)) {
            List<AbstractMapCacheHandler<T>> list = this.cacheHandlerList;
            synchronized (list) {
                t = firstHandler.get(key);
                if (t == null || !firstHandler.validate(key, t)) {
                    Iterator<AbstractMapCacheHandler<T>> iterator = this.cacheHandlerList.iterator();
                    return this.getData(key, iterator, supplier);
                }
            }
        }
        return t;
    }

    private T getData(String key, @NonNull Iterator<AbstractMapCacheHandler<T>> iterator, Supplier<T> supplier) {
        if (iterator == null) {
            throw new NullPointerException("iterator is marked non-null but is null");
        }
        if (!iterator.hasNext()) {
            if (supplier != null) {
                return supplier.get();
            }
            throw new BaseRuntimeException("The cacheHandlerList is empty. Please make sure that the last AbstractCacheHandler<T> instance object can correctly obtain the element.", new Object[0]);
        }
        AbstractMapCacheHandler<T> item = iterator.next();
        T pop = item.get(key);
        if (pop != null) {
            boolean validate = item.validate(key, pop);
            if (validate) {
                return pop;
            }
            log.debug("{}[{}] clear the invalid element", item.getClass(), (Object)item.getTag());
            item.clear(key);
        }
        pop = this.getData(key, iterator, supplier);
        Objects.requireNonNull(pop);
        log.debug("Get the valid elements and cache them in {}[{}]", item.getClass(), (Object)item.getTag());
        item.put(key, pop);
        return pop;
    }

    public MapCacheChain(List<AbstractMapCacheHandler<T>> cacheHandlerList) {
        this.cacheHandlerList = cacheHandlerList;
    }
}

