/*
 * Decompiled with CFR 0.152.
 */
package com.github.cosycode.ext.io.cache;

import com.github.cosycode.common.lang.BaseRuntimeException;
import com.github.cosycode.ext.io.cache.AbstractObjCacheHandler;
import com.github.cosycode.ext.io.cache.ICacheStack;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjCacheChain<T extends ICacheStack> {
    private static final Logger log = LoggerFactory.getLogger(ObjCacheChain.class);
    final List<AbstractObjCacheHandler<T>> cacheHandlerList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getData() {
        Objects.requireNonNull(this.cacheHandlerList);
        if (this.cacheHandlerList.isEmpty()) {
            throw new BaseRuntimeException("cacheHandlerList is empty", new Object[0]);
        }
        AbstractObjCacheHandler<T> firstHandler = this.cacheHandlerList.get(0);
        T t = firstHandler.get();
        if (t == null || !firstHandler.validate(t)) {
            List<AbstractObjCacheHandler<T>> list = this.cacheHandlerList;
            synchronized (list) {
                t = firstHandler.get();
                if (t == null || !firstHandler.validate(t)) {
                    Iterator<AbstractObjCacheHandler<T>> iterator = this.cacheHandlerList.iterator();
                    return this.getData(iterator);
                }
            }
        }
        return t;
    }

    private T getData(@NonNull Iterator<AbstractObjCacheHandler<T>> iterator) {
        if (iterator == null) {
            throw new NullPointerException("iterator is marked non-null but is null");
        }
        if (!iterator.hasNext()) {
            throw new BaseRuntimeException("The cacheHandlerList is empty. Please make sure that the last AbstractCacheHandler<T> instance object can correctly obtain the element.", new Object[0]);
        }
        AbstractObjCacheHandler<T> item = iterator.next();
        T pop = item.get();
        if (pop != null) {
            boolean validate = item.validate(pop);
            if (validate) {
                return pop;
            }
            log.debug("{}[{}] clear the invalid element", item.getClass(), (Object)item.getTag());
            item.clear();
        }
        pop = this.getData(iterator);
        Objects.requireNonNull(pop);
        log.debug("Get the valid elements and cache them in {}[{}]", item.getClass(), (Object)item.getTag());
        item.put(pop);
        return pop;
    }

    public ObjCacheChain(List<AbstractObjCacheHandler<T>> cacheHandlerList) {
        this.cacheHandlerList = cacheHandlerList;
    }
}

