/*
 * Decompiled with CFR 0.152.
 */
package com.github.cosycode.ext.se.robot;

import java.awt.Robot;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import lombok.NonNull;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyPressUtils {
    private static final Logger log = LoggerFactory.getLogger(KeyPressUtils.class);
    private static final int[][] SINGLE_MAPPING = new int[][]{{10, 9, 8, 32, 45, 61, 59, 47, 44, 46, 91, 93, 39, 96}, {10, 9, 8, 32, 45, 61, 59, 47, 44, 46, 91, 93, 222, 192}};
    private static final int[][] SHIFT_AND_MAPPING = new int[][]{{33, 64, 35, 36, 37, 94, 38, 42, 40, 41, 60, 62, 63, 124, 58, 123, 125, 95, 43, 34, 126}, {49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 44, 46, 47, 92, 59, 91, 93, 45, 61, 222, 192}};

    private KeyPressUtils() {
    }

    private static void delay(Robot r, int delay) {
        if (delay > 0) {
            r.delay(delay);
        }
    }

    public static void keyPressByInt(Robot r, int key, int delay) {
        r.keyPress(key);
        r.keyRelease(key);
        KeyPressUtils.delay(r, delay);
    }

    public static void keyPressWithShift(Robot r, int key, int delay) {
        r.keyPress(16);
        r.keyPress(key);
        r.keyRelease(key);
        r.keyRelease(16);
        KeyPressUtils.delay(r, delay);
    }

    public static void keyPressWithCtrl(Robot r, int key, int delay) {
        r.keyPress(17);
        r.keyPress(key);
        r.keyRelease(key);
        r.keyRelease(17);
        KeyPressUtils.delay(r, delay);
    }

    public static void keyPressWithAlt(Robot r, int key, int delay) {
        r.keyPress(18);
        r.keyPress(key);
        r.keyRelease(key);
        r.keyRelease(18);
        KeyPressUtils.delay(r, delay);
    }

    public static boolean keyPressForKeyEvent(Robot r, char key, int delay) {
        if (Character.isLowerCase(key)) {
            KeyPressUtils.keyPressByInt(r, Character.toUpperCase(key), delay);
            return true;
        }
        if (Character.isUpperCase(key)) {
            KeyPressUtils.keyPressWithShift(r, key, delay);
            return true;
        }
        if (Character.isDigit(key)) {
            KeyPressUtils.keyPressByInt(r, key, delay);
            return true;
        }
        int i = ArrayUtils.indexOf((int[])SINGLE_MAPPING[0], (int)key);
        if (i >= 0) {
            KeyPressUtils.keyPressByInt(r, SINGLE_MAPPING[1][i], delay);
            return true;
        }
        int j = ArrayUtils.indexOf((int[])SHIFT_AND_MAPPING[0], (int)key);
        if (j >= 0) {
            KeyPressUtils.keyPressWithShift(r, SHIFT_AND_MAPPING[1][j], delay);
            return true;
        }
        return false;
    }

    public static void keyPressWithString(Robot r, int gbkCode, int delay) {
        r.keyPress(18);
        String s = Integer.toString(gbkCode);
        for (char c : s.toCharArray()) {
            int k = c + 48;
            r.keyPress(k);
            r.keyRelease(k);
            r.delay(0);
        }
        r.keyRelease(18);
        if (delay > 0) {
            r.delay(delay);
        }
    }

    public static void keyPressWithString(Robot r, String string, @NonNull Charset charset, int delay) throws CharacterCodingException {
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        CharsetEncoder ce = charset.newEncoder();
        StringBuilder sb = null;
        for (char c : string.toCharArray()) {
            if (Character.isSurrogate(c)) {
                if (sb == null) {
                    sb = new StringBuilder();
                }
                sb.append(c);
                if (!Character.isLowSurrogate(c)) continue;
                log.warn("cannot print characters: {}", (Object)sb);
                sb.setLength(0);
                continue;
            }
            KeyPressUtils.keyPressWithString(r, c, ce, delay);
        }
        if (sb != null && sb.length() > 0) {
            log.warn(sb.toString());
        }
    }

    public static void keyPressWithString(Robot r, char ch, @NonNull CharsetEncoder charsetEncoder, int delay) throws CharacterCodingException {
        if (charsetEncoder == null) {
            throw new NullPointerException("charsetEncoder is marked non-null but is null");
        }
        if (Character.isSurrogate(ch)) {
            return;
        }
        if (ch >>> 8 == 0) {
            boolean b = KeyPressUtils.keyPressForKeyEvent(r, ch, delay);
            if (b) {
                return;
            }
            KeyPressUtils.keyPressWithString(r, ch, delay);
            return;
        }
        CharBuffer cb = CharBuffer.wrap(new char[]{ch});
        byte[] array = charsetEncoder.encode(cb).array();
        int code = Byte.toUnsignedInt(array[0]) << 8 | Byte.toUnsignedInt(array[1]);
        KeyPressUtils.keyPressWithString(r, code, delay);
    }
}

