/*
 * Decompiled with CFR 0.152.
 */
package com.github.cosycode.ext.se.util;

import com.github.cosycode.common.lang.BaseRuntimeException;
import com.github.cosycode.common.util.io.FileSystemUtils;
import com.github.cosycode.common.util.io.IoUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class DataConvertUtils {
    private DataConvertUtils() {
    }

    public static String fileToBase64(File file) throws IOException {
        try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            long length = file.length();
            if (length > Integer.MAX_VALUE) {
                throw new BaseRuntimeException("the file is too large", new Object[0]);
            }
            byte[] bytes = new byte[(int)length];
            int read = in.read(bytes);
            Validate.isTrue(((long)read == length ? 1 : 0) != 0, (String)"The length of the file read does not match the length of the file itself", (Object[])new Object[0]);
            String string = Base64.getEncoder().encodeToString(bytes);
            return string;
        }
    }

    public static void base64ToFile(String base64, String savePath) throws IOException {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)base64), (String)"The base64 string cannot be empty", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)savePath), (String)"The storage path savePath cannot be empty", (Object[])new Object[0]);
        FileSystemUtils.insureFileExist((File)new File(savePath));
        byte[] bytes = Base64.getDecoder().decode(base64);
        IoUtils.writeFile((String)savePath, (byte[])bytes);
    }
}

