/*
 * Decompiled with CFR 0.152.
 */
package com.github.cosycode.ext.se.util;

import com.github.cosycode.common.util.otr.PrintTool;
import com.google.gson.JsonElement;
import lombok.NonNull;

public class GsonUtils {
    public static JsonElement getJsonElement(JsonElement jsonElement, @NonNull String expression) {
        String[] split;
        if (expression == null) {
            throw new NullPointerException("expression is marked non-null but is null");
        }
        for (String s : split = expression.split("\\.")) {
            if (s.startsWith("[]")) {
                int idx = Integer.parseInt(s.substring(2));
                jsonElement = jsonElement.getAsJsonArray().get(idx);
                continue;
            }
            if (s.startsWith("{}")) {
                String substring = s.substring(2);
                jsonElement = jsonElement.getAsJsonObject().get(substring);
                continue;
            }
            throw new IllegalArgumentException(PrintTool.format((String)"not support the expression: {}, subExpression: {}, json:{}", (Object[])new Object[]{s, expression, jsonElement}));
        }
        return jsonElement;
    }
}

