/*
 * Decompiled with CFR 0.152.
 */
package com.github.cosycode.ext.se.util;

import com.github.cosycode.common.ext.hub.Throws;
import com.github.cosycode.common.lang.NotSupportException;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LambdaUtils {
    private static final Logger log = LoggerFactory.getLogger(LambdaUtils.class);
    private static final Map<Class<?>, SerializedLambda> CLASS_LAMBDA_CACHE = new ConcurrentHashMap();

    public static Object getInstanceByFunctional(@NonNull Object functional) {
        if (functional == null) {
            throw new NullPointerException("functional is marked non-null but is null");
        }
        Field[] declaredFields = functional.getClass().getDeclaredFields();
        if (declaredFields.length < 1) {
            return null;
        }
        Field declaredField = declaredFields[0];
        declaredField.setAccessible(true);
        return Throws.fun((Object)functional, declaredField::get).runtimeExp().value();
    }

    public static Object getLambdaType(@NonNull Object object) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        Method[] declaredMethods = object.getClass().getDeclaredMethods();
        if (declaredMethods.length == 0) {
            return null;
        }
        if (declaredMethods.length != 1) {
            throw new IllegalArgumentException("not support multi method in lambda object");
        }
        Method method = declaredMethods[0];
        Class<?>[] parameterTypes = method.getParameterTypes();
        int length = parameterTypes.length;
        Class<?> returnType = method.getReturnType();
        if (Void.TYPE.equals(returnType)) {
            if (length == 0) {
                return Runnable.class;
            }
            if (length == 1) {
                return Consumer.class;
            }
            if (length == 2) {
                return BiConsumer.class;
            }
            throw new NotSupportException("not support this lambda type");
        }
        if (length == 0) {
            return Supplier.class;
        }
        if (length == 1) {
            return Function.class;
        }
        if (length == 2) {
            return BiFunction.class;
        }
        throw new NotSupportException("not support this lambda type");
    }

    public static SerializedLambda getSerializedLambda(Serializable fn) {
        SerializedLambda lambda = CLASS_LAMBDA_CACHE.get(fn.getClass());
        if (lambda == null) {
            try {
                Method method = fn.getClass().getDeclaredMethod("writeReplace", new Class[0]);
                method.setAccessible(Boolean.TRUE);
                lambda = (SerializedLambda)method.invoke((Object)fn, new Object[0]);
                CLASS_LAMBDA_CACHE.put(fn.getClass(), lambda);
            }
            catch (Exception e) {
                log.error("failed to get SerializedLambda Object", (Throwable)e);
            }
        }
        return lambda;
    }

    private LambdaUtils() {
    }
}

