/*
 * Decompiled with CFR 0.152.
 */
package com.github.cosycode.ext.se.util;

import com.github.cosycode.common.util.otr.PrintTool;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogRecords {
    private static final Logger log = LoggerFactory.getLogger(LogRecords.class);
    private static final LogRecord defaultRecord = new LogRecord();
    private static final List<LogRecord> records = new ArrayList<LogRecord>();

    public static LogRecord defaultRecord() {
        return defaultRecord;
    }

    public static void addRecord(LogRecord logRecord) {
        if (logRecord != null) {
            records.add(logRecord);
        }
    }

    public static void clear() {
        defaultRecord.clear();
    }

    public LogRecord append(String str, Object ... objects) {
        return defaultRecord.append(str, objects);
    }

    public LogRecord logAndAppend(String str, Object ... objects) {
        return defaultRecord.logAndAppend(str, objects);
    }

    public void printAllRow() {
        defaultRecord.printAllRow();
    }

    public static List<LogRecord> getRecords() {
        return records;
    }

    public static class LogRecord {
        private final List<String> rows = new ArrayList<String>();

        public void clear() {
            this.rows.clear();
        }

        public LogRecord append(String str, Object ... objects) {
            this.rows.add(PrintTool.format((String)str, (Object[])objects));
            return this;
        }

        public LogRecord logAndAppend(String str, Object ... objects) {
            String format = PrintTool.format((String)str, (Object[])objects);
            this.rows.add(format);
            PrintTool.info((String)format, (Object[])new Object[0]);
            return this;
        }

        public void printAllRow() {
            for (String s : this.rows) {
                PrintTool.info((String)s, (Object[])new Object[0]);
            }
        }
    }
}

