/*
 * Decompiled with CFR 0.152.
 */
package com.github.cosycode.ext.swing.comp;

import com.github.cosycode.common.base.IMapGetter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class StandardGrid<T extends IMapGetter<String, Object>>
extends JPanel {
    private final JTable table;
    private final JScrollPane scrollPane;
    private final List<ColumnConfig> columnConfigList = new ArrayList<ColumnConfig>();
    private final List<T> data = new ArrayList<T>();
    private final AbstractTableModel tableModel = new StandardTableModel();

    public StandardGrid() {
        this.table = new JTable(this.tableModel);
        this.table.setAutoResizeMode(4);
        this.table.setAutoscrolls(true);
        this.setLayout(new BorderLayout());
        this.add((Component)this.table.getTableHeader(), "North");
        this.scrollPane = new JScrollPane();
        this.scrollPane.getViewport().add(this.table);
        this.add((Component)this.scrollPane, "Center");
    }

    public void add(T t) {
        this.data.add(t);
        this.tableModel.fireTableDataChanged();
    }

    public void add(int index, T t) {
        this.data.add(index, t);
        this.tableModel.fireTableDataChanged();
    }

    public void addBatch(int index, Collection<T> collection) {
        this.data.addAll(index, collection);
        this.tableModel.fireTableRowsInserted(index, index + collection.size() - 1);
    }

    public void insert(int index, T t) {
        this.data.add(index, t);
        this.tableModel.fireTableRowsInserted(index, index);
    }

    public void addAll(Collection<T> c) {
        this.data.addAll(c);
        this.tableModel.fireTableDataChanged();
    }

    public void update(int index, T t) {
        this.data.set(index, t);
        this.tableModel.fireTableRowsUpdated(index, index);
    }

    public void delete(int index) {
        this.delete(index, index);
    }

    public void delete(int firstRow, int lastRow) {
        this.data.removeAll(this.data.subList(firstRow, lastRow));
        this.tableModel.fireTableRowsDeleted(firstRow, lastRow);
    }

    public void setData(Collection<T> c) {
        this.data.clear();
        this.data.addAll(c);
        this.tableModel.fireTableDataChanged();
    }

    public void setColumnConfigList(List<ColumnConfig> list) {
        this.columnConfigList.clear();
        this.columnConfigList.addAll(list);
        this.tableModel.fireTableStructureChanged();
    }

    public void setPreferredScrollableViewportRowSize(int rowSizeVisible) {
        int cols = this.table.getColumnModel().getTotalColumnWidth();
        int rows = this.table.getRowHeight() * rowSizeVisible;
        Dimension d = new Dimension(cols, rows);
        this.table.setPreferredScrollableViewportSize(d);
    }

    public void fireTableDataChanged() {
        this.tableModel.fireTableDataChanged();
    }

    public void fireTableStructureChanged() {
        this.tableModel.fireTableStructureChanged();
    }

    public JTable getTable() {
        return this.table;
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public List<ColumnConfig> getColumnConfigList() {
        return this.columnConfigList;
    }

    public List<T> getData() {
        return this.data;
    }

    public AbstractTableModel getTableModel() {
        return this.tableModel;
    }

    public class StandardTableModel
    extends AbstractTableModel {
        private boolean serialNumberAble = true;
        private boolean cellEditable = true;
        private String orderHeaderName = "";

        @Override
        public String getColumnName(int column) {
            if (this.serialNumberAble) {
                if (column == 0) {
                    return this.orderHeaderName;
                }
                --column;
            }
            return ((ColumnConfig)StandardGrid.this.columnConfigList.get(column)).getText();
        }

        @Override
        public int getRowCount() {
            return StandardGrid.this.data.size();
        }

        @Override
        public int getColumnCount() {
            if (this.serialNumberAble) {
                return StandardGrid.this.columnConfigList.size() + 1;
            }
            return StandardGrid.this.columnConfigList.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (this.serialNumberAble) {
                if (col == 0) {
                    return row + 1;
                }
                --col;
            }
            IMapGetter t = (IMapGetter)StandardGrid.this.data.get(row);
            String key = ((ColumnConfig)StandardGrid.this.columnConfigList.get(col)).getKey();
            return t.get((Object)key);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            if (this.serialNumberAble && column == 0) {
                return false;
            }
            return this.cellEditable;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (this.serialNumberAble) {
                if (col == 0) {
                    return;
                }
                --col;
            }
            IMapGetter t = (IMapGetter)StandardGrid.this.data.get(row);
            String key = ((ColumnConfig)StandardGrid.this.columnConfigList.get(col)).getKey();
            t.put((Object)key, value);
            this.fireTableCellUpdated(row, col);
        }

        public void setSerialNumberAble(boolean serialNumberAble) {
            this.serialNumberAble = serialNumberAble;
        }

        public void setCellEditable(boolean cellEditable) {
            this.cellEditable = cellEditable;
        }

        public String getOrderHeaderName() {
            return this.orderHeaderName;
        }

        public void setOrderHeaderName(String orderHeaderName) {
            this.orderHeaderName = orderHeaderName;
        }
    }

    public static class ColumnConfig {
        private final String key;
        private int index;
        private int width;
        private String text;

        public ColumnConfig(String key, String text) {
            this(key, text, -1, -1);
        }

        public ColumnConfig(String key, String text, int index, int width) {
            this.key = key;
            this.index = index;
            this.width = width;
            this.text = text;
        }

        public String getKey() {
            return this.key;
        }

        public int getIndex() {
            return this.index;
        }

        public int getWidth() {
            return this.width;
        }

        public String getText() {
            return this.text;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public void setText(String text) {
            this.text = text;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ColumnConfig)) {
                return false;
            }
            ColumnConfig other = (ColumnConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getIndex() != other.getIndex()) {
                return false;
            }
            if (this.getWidth() != other.getWidth()) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            return !(this$text == null ? other$text != null : !this$text.equals(other$text));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ColumnConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getIndex();
            result = result * 59 + this.getWidth();
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            return result;
        }

        public String toString() {
            return "StandardGrid.ColumnConfig(key=" + this.getKey() + ", index=" + this.getIndex() + ", width=" + this.getWidth() + ", text=" + this.getText() + ")";
        }
    }
}

