/*
 * Decompiled with CFR 0.152.
 */
package com.github.cosycode.ext.web.http;

import com.github.cosycode.ext.se.util.JsonUtils;
import com.github.cosycode.ext.web.http.Http5ClientConfig;
import com.github.cosycode.ext.web.http.MyHttpResponse;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.HttpResponseException;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);

    private HttpUtils() {
    }

    private static String createRequestUrl(String url, Map<String, String> paramMap) {
        if (paramMap != null && !paramMap.isEmpty()) {
            ArrayList<BasicNameValuePair> paramList = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> stringEntry : paramMap.entrySet()) {
                paramList.add(new BasicNameValuePair(stringEntry.getKey(), stringEntry.getValue()));
            }
            String paramString = paramList.stream().map(it -> it.getName() + "=" + it.getValue()).collect(Collectors.joining("&"));
            if (url.contains("?")) {
                return url + "&" + paramString;
            }
            return url + "?" + paramString;
        }
        return url;
    }

    public static <T> T http(String method, String requestUrl, Map<String, Object> headers, Map<String, String> params, Object jsonBody, HttpClientResponseHandler<? extends T> responseHandler) throws IOException {
        return HttpUtils.http(Http5ClientConfig.getCloseableHttpClient(), method, requestUrl, headers, params, jsonBody, responseHandler);
    }

    public static <T> T http(CloseableHttpClient httpClient, String method, String requestUrl, Map<String, Object> headers, Map<String, String> params, Object jsonBody, HttpClientResponseHandler<? extends T> responseHandler) throws IOException {
        String url = HttpUtils.createRequestUrl(requestUrl, params);
        HttpUriRequestBase httpUriRequestBase = new HttpUriRequestBase(method, URI.create(url));
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry<String, Object> objectEntry : headers.entrySet()) {
                httpUriRequestBase.addHeader((Header)new BasicHeader(objectEntry.getKey(), objectEntry.getValue()));
            }
        }
        String payload = "";
        if (jsonBody != null) {
            payload = jsonBody instanceof String ? (String)jsonBody : JsonUtils.toJson(jsonBody);
            httpUriRequestBase.setEntity((HttpEntity)new StringEntity(payload, StandardCharsets.UTF_8));
        }
        String uuid = UUID.randomUUID().toString().substring(0, 9) + Thread.currentThread().getId();
        Object execute = null;
        try {
            log.info("{} [HTTP Req ] [{}] {}\n{}", new Object[]{uuid, method, url, payload});
            execute = httpClient.execute((ClassicHttpRequest)httpUriRequestBase, responseHandler);
        }
        catch (Exception e) {
            try {
                log.error("{} [HTTP Error ] [{}] {}\n{}", new Object[]{uuid, method, url, payload});
                throw e;
            }
            catch (Throwable throwable) {
                log.info("{} [HTTP Resp] [{}] \n {}", new Object[]{uuid, method, execute});
                throw throwable;
            }
        }
        log.info("{} [HTTP Resp] [{}] \n {}", new Object[]{uuid, method, execute});
        return (T)execute;
    }

    public static MyHttpResponse get(String urlString, Map<String, Object> headers, Map<String, String> params) throws IOException {
        return HttpUtils.http("GET", urlString, headers, params, null, MyHttpResponse.DEFAULT_HANDLER);
    }

    public static MyHttpResponse post(String urlString, Map<String, Object> headers, Map<String, String> params, Object jsonBody) throws IOException {
        return HttpUtils.http("POST", urlString, headers, params, jsonBody, MyHttpResponse.DEFAULT_HANDLER);
    }

    public static MyHttpResponse put(String urlString, Map<String, Object> headers, Map<String, String> params, Object jsonBody) throws IOException {
        return HttpUtils.http("PUT", urlString, headers, params, jsonBody, MyHttpResponse.DEFAULT_HANDLER);
    }

    public static MyHttpResponse delete(String urlString, Map<String, Object> headers, Map<String, String> params, Object jsonBody) throws IOException {
        return HttpUtils.http("DELETE", urlString, headers, params, jsonBody, MyHttpResponse.DEFAULT_HANDLER);
    }

    @Contract(threading=ThreadingBehavior.STATELESS)
    public static class MyStringHttpClientResponseHandler
    implements HttpClientResponseHandler<String> {
        public String handleResponse(ClassicHttpResponse response) throws IOException {
            HttpEntity entity = response.getEntity();
            if (response.getCode() >= 300) {
                EntityUtils.consume((HttpEntity)entity);
                throw new HttpResponseException(response.getCode(), response.getReasonPhrase());
            }
            return entity == null ? null : this.handleEntity(entity);
        }

        public String handleEntity(HttpEntity entity) throws IOException {
            try {
                return EntityUtils.toString((HttpEntity)entity);
            }
            catch (ParseException var3) {
                throw new ClientProtocolException((Throwable)var3);
            }
        }
    }
}

