/*
 * Decompiled with CFR 0.152.
 */
package com.github.cosycode.ext.web.http;

import com.github.cosycode.common.base.SupplierWithThrow;
import com.github.cosycode.common.ext.hub.LazySingleton;
import com.github.cosycode.ext.io.cache.AbstractKeyCacheHandler;
import com.github.cosycode.ext.web.http.Http5ClientConfig;
import com.github.cosycode.ext.web.http.HttpUtils;
import com.github.cosycode.ext.web.http.MyHttpDownloadResponseHandler;
import com.github.cosycode.ext.web.http.MyHttpRequest;
import com.github.cosycode.ext.web.http.MyHttpResponse;
import java.io.IOException;
import java.io.Serializable;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyHttpClient {
    private static final Logger log = LoggerFactory.getLogger(MyHttpClient.class);
    public static final LazySingleton<MyHttpClient> DEFAULT_INSTANCE = LazySingleton.of(() -> {
        MyHttpClient myHttpClient = new MyHttpClient(Http5ClientConfig.getCloseableHttpClient(), MyHttpResponse.DEFAULT_HANDLER);
        myHttpClient.setWebCacheHandler(null);
        myHttpClient.setPreProcess(req -> log.info("[{}] {}", (Object)req.method(), (Object)req.requestUrl()));
        myHttpClient.setPostProcess((req, resp) -> {
            if (resp.isCode(404)) {
                log.warn("[{}] {} ==> {}", new Object[]{req.method(), req.requestUrl(), resp.data()});
            }
        });
        return myHttpClient;
    });
    final CloseableHttpClient closeableHttpClient;
    final HttpClientResponseHandler<MyHttpResponse> httpClientResponseHandler;
    AbstractKeyCacheHandler<MyHttpRequest, MyHttpResponse> webCacheHandler;
    Consumer<MyHttpRequest> preProcess;
    BiConsumer<MyHttpRequest, MyHttpResponse> postProcess;

    public MyHttpClient(CloseableHttpClient closeableHttpClient, HttpClientResponseHandler<MyHttpResponse> httpClientResponseHandler) {
        this.closeableHttpClient = closeableHttpClient;
        this.httpClientResponseHandler = httpClientResponseHandler;
    }

    public static MyHttpResponse send(MyHttpRequest myHttpRequest, CloseableHttpClient closeableHttpClient, AbstractKeyCacheHandler<MyHttpRequest, MyHttpResponse> webCacheHandler, HttpClientResponseHandler<MyHttpResponse> httpClientResponseHandler, Consumer<MyHttpRequest> preProcess, BiConsumer<MyHttpRequest, MyHttpResponse> postProcess) throws IOException {
        if (preProcess != null) {
            preProcess.accept(myHttpRequest);
        }
        MyHttpResponse myHttpResponse = webCacheHandler == null ? MyHttpClient.doSend(myHttpRequest, closeableHttpClient, httpClientResponseHandler) : webCacheHandler.computeIfAbsent(myHttpRequest, (SupplierWithThrow<MyHttpResponse, IOException>)(SupplierWithThrow & Serializable)() -> (MyHttpResponse)MyHttpClient.doSend(myHttpRequest, closeableHttpClient, httpClientResponseHandler), r -> !r.isCode(429));
        if (postProcess != null) {
            postProcess.accept(myHttpRequest, myHttpResponse);
        }
        return myHttpResponse;
    }

    private static <R> R doSend(MyHttpRequest request, CloseableHttpClient closeableHttpClient, HttpClientResponseHandler<R> httpClientResponseHandler) throws IOException {
        return HttpUtils.http(closeableHttpClient, request.method(), request.requestUrl(), request.headers(), request.params(), request.jsonBody(), httpClientResponseHandler);
    }

    public MyHttpResponse send(MyHttpRequest myHttpRequest) throws IOException {
        return MyHttpClient.send(myHttpRequest, this.closeableHttpClient, this.webCacheHandler, this.httpClientResponseHandler, this.preProcess, this.postProcess);
    }

    public MyHttpResponse download(MyHttpRequest myHttpRequest, String savePath) throws IOException {
        MyHttpDownloadResponseHandler responseHandler = new MyHttpDownloadResponseHandler(savePath);
        return MyHttpClient.send(myHttpRequest, this.closeableHttpClient, null, responseHandler, this.preProcess, null);
    }

    public MyHttpClient setWebCacheHandler(AbstractKeyCacheHandler<MyHttpRequest, MyHttpResponse> webCacheHandler) {
        this.webCacheHandler = webCacheHandler;
        return this;
    }

    public MyHttpClient setPreProcess(Consumer<MyHttpRequest> preProcess) {
        this.preProcess = preProcess;
        return this;
    }

    public MyHttpClient setPostProcess(BiConsumer<MyHttpRequest, MyHttpResponse> postProcess) {
        this.postProcess = postProcess;
        return this;
    }

    public CloseableHttpClient getCloseableHttpClient() {
        return this.closeableHttpClient;
    }

    public HttpClientResponseHandler<MyHttpResponse> getHttpClientResponseHandler() {
        return this.httpClientResponseHandler;
    }

    public AbstractKeyCacheHandler<MyHttpRequest, MyHttpResponse> getWebCacheHandler() {
        return this.webCacheHandler;
    }

    public Consumer<MyHttpRequest> getPreProcess() {
        return this.preProcess;
    }

    public BiConsumer<MyHttpRequest, MyHttpResponse> getPostProcess() {
        return this.postProcess;
    }
}

