/*
 * Decompiled with CFR 0.152.
 */
package com.github.cosycode.ext.web.http;

import com.github.cosycode.common.lang.BaseRuntimeException;
import com.github.cosycode.ext.se.util.JsonUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.HttpResponseException;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;

public class MyHttpResponse {
    public static final HttpClientResponseHandler<MyHttpResponse> DEFAULT_HANDLER = response -> {
        int responseCode = response.getCode();
        HttpEntity entity = response.getEntity();
        if (responseCode < 500 && responseCode >= 200) {
            String responseData;
            if (entity == null) {
                responseData = null;
            } else {
                try {
                    responseData = EntityUtils.toString((HttpEntity)entity);
                }
                catch (ParseException var3) {
                    throw new ClientProtocolException((Throwable)var3);
                }
            }
            return new MyHttpResponse(responseCode, responseData);
        }
        try {
            String responseData = EntityUtils.toString((HttpEntity)entity);
            return new MyHttpResponse(responseCode, responseData);
        }
        catch (ParseException var3) {
            EntityUtils.consume((HttpEntity)entity);
            throw new HttpResponseException(responseCode, response.getReasonPhrase());
        }
    };
    private final int code;
    private final String data;
    private String contentType;

    public MyHttpResponse(int code, String data) {
        this.code = code;
        this.data = data;
    }

    public <T> T jsonParse(Class<T> tClass) {
        if (!this.isSuccess() || StringUtils.isBlank((CharSequence)this.data)) {
            throw new BaseRuntimeException("can't convert to %s, ==> %s", new Object[]{tClass.getName(), this});
        }
        return JsonUtils.fromJson(this.data, tClass);
    }

    public boolean isSuccess() {
        return this.code >= 200 && this.code < 300;
    }

    public boolean isCode(int number) {
        return this.code == number;
    }

    public int code() {
        return this.code;
    }

    public String data() {
        return this.data;
    }

    public String contentType() {
        return this.contentType;
    }

    public MyHttpResponse contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MyHttpResponse)) {
            return false;
        }
        MyHttpResponse other = (MyHttpResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.code() != other.code()) {
            return false;
        }
        String this$data = this.data();
        String other$data = other.data();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$contentType = this.contentType();
        String other$contentType = other.contentType();
        return !(this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MyHttpResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.code();
        String $data = this.data();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $contentType = this.contentType();
        result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
        return result;
    }

    public String toString() {
        return "MyHttpResponse(code=" + this.code() + ", data=" + this.data() + ", contentType=" + this.contentType() + ")";
    }
}

