/*
 * Decompiled with CFR 0.152.
 */
package com.github.cpprofiler;

import com.github.cpprofiler.Message;
import org.zeromq.ZMQ;

public class Connector {
    private ZMQ.Context context;
    private ZMQ.Socket socket;

    public Connector() {
        System.out.println("Connector initialized v1.0.0!");
        this.context = ZMQ.context((int)1);
        this.socket = this.context.socket(8);
    }

    public void connect(int port) {
        this.socket.connect("tcp://localhost:" + port);
    }

    public void disconnect() {
        Message.Node msg = Message.Node.newBuilder().setType(Message.Node.MsgType.DONE).build();
        this.sendOverSocket(msg);
        this.socket.close();
        this.context.term();
    }

    public ExtendedNode createNode(int sid, int pid, int alt, int kids, NodeStatus status) {
        ExtendedNode node = new ExtendedNode(this, sid, pid, alt, kids, status);
        return node;
    }

    public void sendNode(int sid, int pid, int alt, int kids, NodeStatus status, String label, String info) {
        Message.Node node = Message.Node.newBuilder().setType(Message.Node.MsgType.NODE).setSid(sid).setPid(pid).setAlt(alt).setKids(kids).setStatus(Message.Node.NodeStatus.valueOf(status.getNumber())).setLabel(label).setInfo(info).build();
        this.sendOverSocket(node);
    }

    public void restart(int rid) {
        Message.Node msg = Message.Node.newBuilder().setType(Message.Node.MsgType.START).setRestartId(rid).build();
        this.sendOverSocket(msg);
    }

    public void restart() {
        this.restart(-1);
    }

    private void sendOverSocket(Message.Node msg) {
        this.socket.send(msg.toByteArray(), 0);
    }

    public class ExtendedNode {
        Message.Node.Builder builder = Message.Node.newBuilder();
        Connector _connector;

        public ExtendedNode(Connector connector, int sid, int pid, int alt, int kids, NodeStatus status) {
            this.builder.setType(Message.Node.MsgType.NODE).setSid(sid).setPid(pid).setAlt(alt).setKids(kids).setStatus(Message.Node.NodeStatus.valueOf(status.getNumber()));
            this._connector = connector;
        }

        public ExtendedNode setLabel(String label) {
            this.builder.setLabel(label);
            return this;
        }

        public ExtendedNode setInfo(String info) {
            this.builder.setInfo(info);
            return this;
        }

        public void send() {
            Message.Node msg = this.builder.build();
            this._connector.sendOverSocket(msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NodeStatus {
        SOLVED(0),
        FAILED(1),
        BRANCH(2),
        SKIPPED(6);

        private final int id;

        private NodeStatus(int id) {
            this.id = id;
        }

        public int getNumber() {
            return this.id;
        }
    }
}

