/*
 * Decompiled with CFR 0.152.
 */
package com.github.cpprofiler;

import message.Message;
import org.zeromq.ZMQ;

public class Connector {
    private ZMQ.Context context;
    private ZMQ.Socket socket;

    public Connector() {
        System.out.println("Connector initialized!");
        this.context = ZMQ.context((int)1);
        this.socket = this.context.socket(8);
    }

    public void connectToSocket(int port) {
        this.socket.connect("tcp://localhost:" + port);
        System.out.println("connected over port: " + port);
    }

    public void disconnectFromSocket() {
        Message.Node msg = Message.Node.newBuilder().setType(Message.Node.MsgType.DONE).build();
        this.sendOverSocket(msg);
        this.socket.close();
        this.context.term();
    }

    public void sendNode(int sid, int pid, int alt, int kids, Message.Node.NodeStatus status, String label, String info) {
        Message.Node node = Message.Node.newBuilder().setType(Message.Node.MsgType.NODE).setSid(sid).setPid(pid).setAlt(alt).setKids(kids).setStatus(status).setLabel(label).setInfo(info).build();
        this.sendOverSocket(node);
    }

    public void restartGist(int rid) {
        Message.Node msg = Message.Node.newBuilder().setType(Message.Node.MsgType.START).setRestartId(rid).build();
        this.sendOverSocket(msg);
    }

    private void sendOverSocket(Message.Node msg) {
        this.socket.send(msg.toByteArray(), 0);
    }
}

