/*
 * Decompiled with CFR 0.152.
 */
package com.java_podio.code_gen.static_classes;

import com.java_podio.code_gen.static_classes.PodioField;
import com.podio.item.FieldValuesUpdate;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Currency;
import java.util.HashMap;
import java.util.Locale;

public class PodioCurrency
implements PodioField {
    private static final long serialVersionUID = 1L;
    public static ThreadLocal<NumberFormat> currencyValueFormatter = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            NumberFormat format = DecimalFormat.getInstance(Locale.US);
            format.setGroupingUsed(false);
            return format;
        }
    };
    private Currency currency;
    private Double value;

    public PodioCurrency() {
        this.currency = Currency.getInstance(Locale.getDefault());
    }

    public PodioCurrency(Double value) {
        this.value = value;
        this.currency = Currency.getInstance(Locale.getDefault());
    }

    public PodioCurrency(Double value, String currency) {
        this.value = value;
        this.currency = Currency.getInstance(currency);
    }

    public Currency getcurrency() {
        return this.currency;
    }

    public void setcurrency(Currency currency) {
        this.currency = currency;
    }

    public Double getvalue() {
        return this.value;
    }

    public void setvalue(Double value) {
        this.value = value;
    }

    @Override
    public FieldValuesUpdate getFieldValuesUpdate(String externalId) {
        HashMap<String, String> valueMap = new HashMap<String, String>();
        valueMap.put("currency", this.getcurrency().getCurrencyCode());
        valueMap.put("value", currencyValueFormatter.get().format(this.getvalue()));
        FieldValuesUpdate result = new FieldValuesUpdate(externalId, valueMap);
        return result;
    }

    public String toString() {
        String result = "PodioCurrency [";
        result = result + "currency=" + this.currency;
        result = result + ", value=" + this.value;
        return result + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.currency == null ? 0 : this.currency.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PodioCurrency other = (PodioCurrency)obj;
        if (this.currency == null ? other.currency != null : !this.currency.equals(other.currency)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public static PodioCurrency parseString(String text) throws ParseException {
        if (text == null) {
            return null;
        }
        if ((text = text.trim()).length() == 0) {
            return null;
        }
        NumberFormat numberFormat = DecimalFormat.getNumberInstance();
        numberFormat.setGroupingUsed(false);
        double value = numberFormat.parse(text).doubleValue();
        return new PodioCurrency(value);
    }

    public static String toString(PodioCurrency currency, NumberFormat format) {
        if (currency == null) {
            return "";
        }
        if (currency.getvalue() == null) {
            return "";
        }
        return format.format(currency.getvalue());
    }
}

