/*
 * Decompiled with CFR 0.152.
 */
package com.java_podio.code_gen.static_interface;

import com.java_podio.code_gen.static_interface.GenericPodioInterface;
import com.podio.APIApplicationException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLProtocolException;
import javax.ws.rs.ProcessingException;

public abstract class RateLimitRetry {
    private static final int NUMBER_OF_RETRIES = 3;
    private static final Logger LOGGER = Logger.getLogger(RateLimitRetry.class.getName());
    private static List<RateLimitHitListener> listener = new LinkedList<RateLimitHitListener>();

    public static void addRateLimitHitListener(RateLimitHitListener l) {
        listener.add(l);
    }

    public static void removeRateLimitHitListener(RateLimitHitListener l) {
        listener.remove(l);
    }

    public static <T extends GenericPodioInterface> T proxify(T original, Class<T> interfaceType, boolean retrySslError) {
        LOGGER.info("Using GenericPodioInterfaceProxy on " + original.getClass().getCanonicalName());
        return (T)((GenericPodioInterface)Proxy.newProxyInstance(interfaceType.getClassLoader(), new Class[]{interfaceType}, new RateLimitInvokationHandler<T>(original, interfaceType, retrySslError)));
    }

    public static <T extends GenericPodioInterface> T proxify(T original, Class<T> interfaceType) {
        return RateLimitRetry.proxify(original, interfaceType, false);
    }

    public static interface RateLimitHitListener {
        public void hitRateLimit(int var1, int var2);
    }

    private static class RateLimitInvokationHandler<T extends GenericPodioInterface>
    implements InvocationHandler {
        private final T original;
        private final boolean retrySslError;

        public RateLimitInvokationHandler(T original, Class<T> interfaceType, boolean retrySslError) {
            this.original = original;
            this.retrySslError = retrySslError;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            int i = 0;
            while (true) {
                try {
                    return method.invoke(this.original, args);
                }
                catch (InvocationTargetException e) {
                    if (i == 3) {
                        LOGGER.warning("giving up after 3 retries.");
                        throw new RetriesFailedException("giving up after 3 retries.", e);
                    }
                    if (e.getCause() instanceof APIApplicationException && "rate_limit".equals(((APIApplicationException)e.getCause()).getError())) {
                        APIApplicationException exc = (APIApplicationException)e.getCause();
                        Pattern pattern = Pattern.compile("Please wait (\\d+) seconds", 2);
                        Matcher matcher = pattern.matcher(exc.getDescription());
                        if (!matcher.find()) {
                            LOGGER.warning("could not parse wait time from: " + exc.getDescription() + " (throwing exception)");
                            throw e;
                        }
                        String seconds = matcher.group(1);
                        LOGGER.info("should wait for " + seconds + " seconds..");
                        int secondsInt = Integer.parseInt(seconds);
                        for (RateLimitHitListener l : listener) {
                            l.hitRateLimit(i, secondsInt);
                        }
                        Thread.sleep(secondsInt * 1000);
                        LOGGER.info("waking up, trying again..");
                    } else if (this.retrySslError && e.getTargetException() instanceof ProcessingException && (e.getTargetException().getCause() instanceof SSLProtocolException || e.getTargetException().getCause().getCause() instanceof SSLProtocolException)) {
                        LOGGER.info("Retrying SSL error in 10ms: " + e.getMessage());
                        Thread.sleep(10L);
                    } else {
                        LOGGER.log(Level.INFO, "non rate limit exception occured..", e);
                        throw e;
                    }
                    ++i;
                    continue;
                }
                break;
            }
        }
    }

    public static class RetriesFailedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public RetriesFailedException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

