/*
 * Decompiled with CFR 0.152.
 */
package com.podio.codegen;

import com.java_podio.code_gen.CodeGenMain;
import com.sun.codemodel.JClassAlreadyExistsException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class PodioCodeGenMojo
extends AbstractMojo {
    @Parameter(required=true)
    private String user;
    @Parameter(required=true)
    private String password;
    @Parameter
    private Integer spaceId;
    @Parameter
    private List<Integer> appIds;
    @Parameter(defaultValue="podio.generated")
    private String basePackage;
    @Parameter(defaultValue="${project.build.sourceDirectory}", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="UTF-8")
    private String encoding;

    public void execute() throws MojoExecutionException, MojoFailureException {
        block6: {
            if (!this.outputDirectory.exists()) {
                this.outputDirectory.mkdirs();
            }
            this.getLog().debug((CharSequence)("user=" + this.user));
            this.getLog().debug((CharSequence)("password=" + this.password));
            this.getLog().debug((CharSequence)("spaceId=" + this.spaceId));
            this.getLog().debug((CharSequence)("appIds=" + this.appIds));
            this.getLog().debug((CharSequence)("basePackage=" + this.basePackage));
            this.getLog().debug((CharSequence)("outputDirectory=" + this.outputDirectory.toString()));
            try {
                if (this.spaceId != null && this.spaceId > 0) {
                    CodeGenMain.generateSpace((String)this.user, (String)this.password, (Integer)this.spaceId, (File)this.outputDirectory, (String)this.basePackage, (String)this.encoding);
                    break block6;
                }
                if (this.appIds != null && this.appIds.size() > 0) {
                    CodeGenMain.generateApps((String)this.user, (String)this.password, this.appIds, (File)this.outputDirectory, (String)this.basePackage, (String)this.encoding);
                    break block6;
                }
                throw new MojoFailureException("Must provide either spaceId or appIds!");
            }
            catch (JClassAlreadyExistsException e) {
                throw new MojoExecutionException("Error: duplicate classes!", (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error: could not write classes!", (Exception)e);
            }
        }
    }
}

