/*
 * Decompiled with CFR 0.152.
 */
package com.github.deinok.threading;

import com.github.deinok.threading.OnSuccess;
import com.github.deinok.threading.RuntimeThreadException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Task<T> {
    @NotNull
    private final Promise<T> promise;

    public Task(@NotNull Callable<T> callable) {
        this.promise = new Promise<T>(callable);
    }

    public int getPriority() {
        return this.promise.getPriority();
    }

    @NotNull
    public Task<T> setPriority(int newPriority) {
        this.promise.setPriority(newPriority);
        return this;
    }

    @NotNull
    public Task<T> executeAsync() {
        this.promise.executeAsync();
        return this;
    }

    @NotNull
    public Task<T> executeSync() {
        this.promise.executeSync();
        return this;
    }

    @NotNull
    public Task<T> await() {
        this.promise.await();
        return this;
    }

    @Nullable
    public T getResult() throws RuntimeThreadException {
        try {
            return (T)this.promise.get();
        }
        catch (ExecutionException e) {
            throw new RuntimeThreadException(e.getCause());
        }
        catch (InterruptedException e) {
            throw new RuntimeThreadException(e);
        }
    }

    @NotNull
    public Task<T> onSuccess(@NotNull OnSuccess<T> onSuccess) {
        this.promise.setOnSuccess(onSuccess);
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Promise<R>
    extends FutureTask<R> {
        @NotNull
        private final Thread thread;
        @Nullable
        private OnSuccess<R> onSuccess;

        public Promise(Callable<R> callable) {
            super(callable);
            this.thread = new Thread(this);
        }

        @NotNull
        public Promise<R> setOnSuccess(@NotNull OnSuccess<R> onSuccess) {
            this.onSuccess = onSuccess;
            return this;
        }

        @NotNull
        public Promise<R> executeAsync() {
            if (this.thread.getState() == Thread.State.NEW) {
                this.thread.start();
            }
            return this;
        }

        @NotNull
        public Promise<R> executeSync() {
            if (this.thread.getState() == Thread.State.NEW) {
                this.thread.run();
            }
            return this;
        }

        public int getPriority() {
            return this.thread.getPriority();
        }

        @NotNull
        public Promise<R> setPriority(int newPriority) {
            if (this.thread.getState() == Thread.State.NEW) {
                this.thread.setPriority(newPriority);
            }
            return this;
        }

        @NotNull
        public Promise<R> await() {
            switch (this.thread.getState()) {
                case NEW: {
                    return this.executeAsync().await();
                }
                case RUNNABLE: {
                    this.join();
                    return this.await();
                }
                case BLOCKED: {
                    this.join();
                    return this.await();
                }
                case WAITING: {
                    this.join();
                    return this.await();
                }
                case TIMED_WAITING: {
                    this.join();
                    return this.await();
                }
                case TERMINATED: {
                    return this;
                }
            }
            throw new IllegalThreadStateException();
        }

        @Override
        protected void done() throws RuntimeThreadException {
            super.done();
            if (this.onSuccess != null) {
                try {
                    this.onSuccess.execute(this.get());
                }
                catch (ExecutionException e) {
                    throw new RuntimeThreadException(e.getCause());
                }
                catch (InterruptedException e) {
                    throw new RuntimeThreadException(e);
                }
            }
        }

        private void join() {
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

