/*
 * Decompiled with CFR 0.152.
 */
package com.github.deinok.threading.group;

import com.github.deinok.threading.OnSuccess;
import com.github.deinok.threading.Task;
import com.github.deinok.threading.group.ITaskGroup;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskList<R>
extends LinkedList<Task<R>>
implements ITaskGroup<R> {
    @Override
    @NotNull
    public ITaskGroup<R> executeAsync() {
        for (Task task : this) {
            task.executeAsync();
        }
        return this;
    }

    @Override
    @NotNull
    public ITaskGroup<R> executeSync() {
        for (Task task : this) {
            task.executeSync();
        }
        return this;
    }

    @Override
    public int getPriority() {
        int result = 0;
        for (Task task : this) {
            result += task.getPriority();
        }
        return result / this.size();
    }

    @Override
    @NotNull
    public ITaskGroup<R> setPriority(int priority) {
        for (Task task : this) {
            task.setPriority(priority);
        }
        return this;
    }

    @Override
    public boolean cancel() {
        for (Task task : this) {
            boolean cancelled = task.cancel();
            if (cancelled) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public ITaskGroup<R> await() {
        for (Task task : this) {
            task.await();
        }
        return this;
    }

    @Override
    @NotNull
    public List<R> getResult() {
        ArrayList results = new ArrayList(this.size());
        for (Task task : this) {
            results.add(task.getResult());
        }
        return results;
    }

    @Override
    @NotNull
    public ITaskGroup<R> onSuccess(@NotNull OnSuccess<R> onSuccess) {
        for (Task task : this) {
            task.onSuccess(onSuccess);
        }
        return this;
    }
}

