/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.NonNull;

public final class CollectionAdvice {
    public static <E, R> boolean contains(@NonNull Collection<E> collection, R target, @NonNull Function<E, R> function) {
        if (collection == null) {
            throw new NullPointerException("collection is marked non-null but is null");
        }
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        for (E item : collection) {
            R value = function.apply(item);
            if (target == null) {
                return value == null;
            }
            if (!target.equals(value)) continue;
            return true;
        }
        return false;
    }

    public static <E, R> Optional<E> getFirstMatch(@NonNull Collection<E> collection, R target, @NonNull Function<E, R> function) {
        if (collection == null) {
            throw new NullPointerException("collection is marked non-null but is null");
        }
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        for (E item : collection) {
            R value = function.apply(item);
            if (target == null) {
                return value == null ? Optional.ofNullable(item) : Optional.empty();
            }
            if (!target.equals(value)) continue;
            return Optional.ofNullable(item);
        }
        return Optional.empty();
    }

    public static <E, R> List<E> getAllMatch(@NonNull Collection<E> collection, R target, @NonNull Function<E, R> function) {
        if (collection == null) {
            throw new NullPointerException("collection is marked non-null but is null");
        }
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        return collection.stream().filter(item -> {
            Object value = function.apply(item);
            if (target == null) {
                return value == null;
            }
            return target.equals(value);
        }).collect(Collectors.toList());
    }

    public static <E, K, V> Map<K, V> toMap(@NonNull Collection<E> collection, @NonNull Function<E, K> keySupplier, @NonNull Function<E, V> valueSupplier) {
        if (collection == null) {
            throw new NullPointerException("collection is marked non-null but is null");
        }
        if (keySupplier == null) {
            throw new NullPointerException("keySupplier is marked non-null but is null");
        }
        if (valueSupplier == null) {
            throw new NullPointerException("valueSupplier is marked non-null but is null");
        }
        HashMap<K, V> map = new HashMap<K, V>();
        for (E item : collection) {
            map.put(keySupplier.apply(item), valueSupplier.apply(item));
        }
        return map;
    }

    @SafeVarargs
    public static <E> Set<E> union(Collection<E> master, Collection<E> ... other) {
        HashSet<E> set = new HashSet<E>(master);
        for (Collection<E> collection : other) {
            set.addAll(collection);
        }
        return set;
    }

    @SafeVarargs
    public static <E> Set<E> intersection(Collection<E> master, Collection<E> ... other) {
        HashSet<Object> set = new HashSet<Object>(master);
        for (Collection<E> collection : other) {
            set.removeIf(Predicate.not(collection::contains));
        }
        return set;
    }
}

