/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.utils;

public final class JavaBeanUtils {
    public static String getGetterMethodName(String property, Class<?> javaType) {
        StringBuilder sb = new StringBuilder();
        sb.append(property);
        if (Character.isLowerCase(sb.charAt(0)) && (sb.length() == 1 || !Character.isUpperCase(sb.charAt(1)))) {
            sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        }
        if (javaType == Boolean.TYPE || javaType == Boolean.class) {
            sb.insert(0, "is");
        } else {
            sb.insert(0, "get");
        }
        return sb.toString();
    }

    public static String getSetterMethodName(String property) {
        StringBuilder sb = new StringBuilder();
        sb.append(property);
        if (Character.isLowerCase(sb.charAt(0)) && (sb.length() == 1 || !Character.isUpperCase(sb.charAt(1)))) {
            sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        }
        sb.insert(0, "set");
        return sb.toString();
    }

    public static String camelcaseToUnderline(String camelcaseString) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < camelcaseString.length(); ++i) {
            char c = camelcaseString.charAt(i);
            if (i != 0 && c >= 'A' && c <= 'Z') {
                sb.append('_').append((char)(c + 32));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String camelcaseToMiddleLine(String camelcaseString) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < camelcaseString.length(); ++i) {
            char c = camelcaseString.charAt(i);
            if (i != 0 && c >= 'A' && c <= 'Z') {
                sb.append('-').append((char)(c + 32));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String underlineToCamelcase(String underlineString) {
        StringBuilder sb = new StringBuilder();
        boolean nextUpperCase = false;
        for (int i = 0; i < underlineString.length(); ++i) {
            char c = underlineString.charAt(i);
            if (c == '_') {
                nextUpperCase = i != 0;
                continue;
            }
            if (nextUpperCase) {
                sb.append((char)(c - 32));
                nextUpperCase = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String middleLineToCamelcase(String middleLineString) {
        StringBuilder sb = new StringBuilder();
        boolean nextUpperCase = false;
        for (int i = 0; i < middleLineString.length(); ++i) {
            char c = middleLineString.charAt(i);
            if (c == '-') {
                nextUpperCase = i != 0;
                continue;
            }
            if (nextUpperCase) {
                sb.append((char)(c - 32));
                nextUpperCase = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

