/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.components;

import develop.toolkit.base.struct.KeyValuePairs;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class Counter<K> {
    private ConcurrentHashMap<K, Integer> map = new ConcurrentHashMap();

    public void add(K key, int count) {
        this.map.compute(key, (k, v) -> v == null ? count : v + count);
    }

    public void add(K key) {
        this.add(key, 1);
    }

    public void subtract(K key, int count) {
        this.map.compute(key, (k, v) -> v == null || v == count ? 0 : v - count);
    }

    public void subtract(K key) {
        this.subtract(key, 1);
    }

    public int get(K key) {
        return this.map.getOrDefault(key, 0);
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public KeyValuePairs<K, Integer> toKeyValuePairs() {
        return KeyValuePairs.fromMap(this.map);
    }
}

