/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.utils;

import develop.toolkit.base.components.Counter;
import develop.toolkit.base.struct.CollectionInMap;
import develop.toolkit.base.struct.KeyValuePairs;
import develop.toolkit.base.struct.TwoValues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class CollectionAdvice {
    public static <E> boolean contains(Collection<E> collection, Object target, Function<E, ?> function) {
        if (collection != null) {
            for (E item : collection) {
                Object value = function.apply(item);
                if (target == null) {
                    return value == null;
                }
                if (!target.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    public static <E> Optional<E> getFirstMatch(Collection<E> collection, Object target, Function<E, ?> function) {
        if (collection != null) {
            for (E item : collection) {
                Object value = function.apply(item);
                if (!(target != null ? target.equals(value) : value == null)) continue;
                return Optional.ofNullable(item);
            }
        }
        return Optional.empty();
    }

    public static <E> Optional<E> getFirstMatch(Collection<E> collection, Object target) {
        if (collection != null && target != null) {
            for (E item : collection) {
                if (!target.equals(item)) continue;
                return Optional.of(item);
            }
        }
        return Optional.empty();
    }

    public static <E> Optional<E> getFirstTrue(Collection<E> collection, Predicate<E> predicate) {
        if (collection != null) {
            for (E item : collection) {
                if (!predicate.test(item)) continue;
                return Optional.ofNullable(item);
            }
        }
        return Optional.empty();
    }

    public static <E> Optional<E> getFirstFalse(Collection<E> collection, Predicate<E> predicate) {
        if (collection != null) {
            for (E item : collection) {
                if (predicate.test(item)) continue;
                return Optional.ofNullable(item);
            }
        }
        return Optional.empty();
    }

    public static <E> List<E> getAllMatch(Collection<E> collection, Object target, Function<E, ?> function) {
        if (collection == null) {
            return null;
        }
        return collection.stream().filter(item -> {
            Object value;
            Object object = value = function == null ? item : function.apply(item);
            if (target == null) {
                return value == null;
            }
            return target.equals(value);
        }).collect(Collectors.toList());
    }

    public static <E> boolean allMatch(Collection<E> collection, Predicate<E> predicate) {
        if (predicate == null || collection == null) {
            return false;
        }
        for (E e : collection) {
            if (predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    public static <E> boolean anyMatch(Collection<E> collection, Predicate<E> predicate) {
        if (collection != null && predicate != null) {
            for (E e : collection) {
                if (!predicate.test(e)) continue;
                return true;
            }
        }
        return false;
    }

    public static <E> boolean allAccept(Collection<E> collection, Function<E, ?> function) {
        if (collection == null || collection.isEmpty()) {
            return false;
        }
        ArrayList<E> list = new ArrayList<E>(collection);
        Object targetValue = function == null ? list.get(0) : function.apply(list.get(0));
        int size = list.size();
        for (int i = 1; i < size; ++i) {
            Object itemValue;
            Object object = itemValue = function == null ? list.get(i) : function.apply(list.get(i));
            if ((targetValue == null || targetValue.equals(itemValue)) && (targetValue != null || itemValue == null)) continue;
            return false;
        }
        return true;
    }

    public static <E, K, V> CollectionInMap<K, V> grouping(Collection<E> collection, Function<E, K> keySupplier, Function<E, V> valueSupplier) {
        CollectionInMap map = new CollectionInMap();
        collection.forEach(item -> map.putItemSoft(keySupplier.apply(item), valueSupplier.apply(item)));
        return map;
    }

    public static <K, V> CollectionInMap<K, V> grouping(Collection<V> collection, Function<V, K> keySupplier) {
        CollectionInMap map = new CollectionInMap();
        collection.forEach(item -> map.putItemSoft(keySupplier.apply(item), item));
        return map;
    }

    public static <K, V> Map<K, V> groupingUniqueKey(Collection<V> collection, Function<V, K> keySupplier) {
        HashMap map = new HashMap();
        collection.forEach(item -> map.put(keySupplier.apply(item), item));
        return map;
    }

    public static <E, K> Counter<K> groupingCount(Collection<E> collection, Function<E, K> keySupplier) {
        Counter counter = new Counter();
        collection.forEach(item -> counter.add(keySupplier.apply(item)));
        return counter;
    }

    @SafeVarargs
    public static <E> Set<E> union(Collection<E> master, Collection<E> ... other) {
        HashSet<E> set = new HashSet<E>(master);
        for (Collection<E> collection : other) {
            set.addAll(collection);
        }
        return set;
    }

    @SafeVarargs
    public static <E> Set<E> intersection(Collection<E> master, Collection<E> ... other) {
        HashSet<Object> set = new HashSet<Object>(master);
        for (Collection<E> collection : other) {
            set.removeIf(Predicate.not(collection::contains));
        }
        return set;
    }

    public static <E> Set<E> complementary(Collection<E> master, Collection<E> other) {
        HashSet<Object> set = new HashSet<Object>(master);
        set.removeIf(other::contains);
        return set;
    }

    @SafeVarargs
    public static <E> Collection<E> merge(Supplier<Collection<E>> supplier, Collection<E> ... collections) {
        Collection<E> collection = supplier.get();
        for (Collection<E> coll : collections) {
            collection.addAll(coll);
        }
        return collection;
    }

    public static <E, T> CollectionInMap<E, T> associate(Collection<E> master, Collection<T> target, BiPredicate<E, T> predicate) {
        CollectionInMap<E, T> map = new CollectionInMap<E, T>();
        for (E e : master) {
            for (T t : target) {
                if (!predicate.test(e, t)) continue;
                map.putItemSoft(e, t);
            }
        }
        return map;
    }

    public static <E, T> KeyValuePairs<E, T> associateOne(Collection<E> master, Collection<T> target, BiPredicate<E, T> predicate) {
        KeyValuePairs<E, Object> keyValuePairs = new KeyValuePairs<E, Object>();
        for (Object e : master) {
            Object matchT = CollectionAdvice.getFirstTrue(target, t -> predicate.test(e, t)).orElse(null);
            keyValuePairs.addKeyValue(e, matchT);
        }
        return keyValuePairs;
    }

    public static <E> TwoValues<List<E>, List<E>> partition(Collection<E> collection, Predicate<E> predicate) {
        LinkedList<E> match = new LinkedList<E>();
        LinkedList<E> notMatch = new LinkedList<E>();
        for (E e : collection) {
            if (predicate.test(e)) {
                match.add(e);
                continue;
            }
            notMatch.add(e);
        }
        return TwoValues.of(match, notMatch);
    }

    public static <E> List<TwoValues<E, E>> zip(List<E> master, List<E> other) {
        if (master.size() != other.size()) {
            throw new IllegalArgumentException("list size must be same");
        }
        LinkedList<TwoValues<TwoValues<E, E>, TwoValues<E, E>>> list = new LinkedList<TwoValues<TwoValues<E, E>, TwoValues<E, E>>>();
        for (int i = 0; i < master.size(); ++i) {
            list.add(TwoValues.of(master.get(i), other.get(i)));
        }
        return list;
    }

    public static <T> void pagingProcess(List<T> list, int size, Consumer<List<T>> consumer) {
        int total = list.size();
        int page = total % size == 0 ? total / size : total / size + 1;
        for (int i = 0; i < page; ++i) {
            int fromIndex = i * size;
            int toIndex = fromIndex + Math.min(total - fromIndex, size);
            List<T> subList = list.subList(fromIndex, toIndex);
            consumer.accept(subList);
        }
    }

    public static <T, S> List<T> sort(Collection<T> master, Collection<S> sortTarget, BiPredicate<T, S> predicate) {
        return sortTarget.stream().map(s -> CollectionAdvice.getFirstTrue(master, c -> predicate.test(c, s)).orElse(null)).collect(Collectors.toList());
    }

    public static <T, S> List<T> sort(Collection<T> master, S[] sortTarget, BiPredicate<T, S> predicate) {
        return Stream.of(sortTarget).map(s -> CollectionAdvice.getFirstTrue(master, c -> predicate.test(c, s)).orElse(null)).collect(Collectors.toList());
    }
}

