/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.utils;

import lombok.NonNull;

public final class CompareAdvice {
    public static <T extends Comparable<T>> boolean lt(@NonNull T a, @NonNull T b) {
        if (a == null) {
            throw new NullPointerException("a is marked non-null but is null");
        }
        if (b == null) {
            throw new NullPointerException("b is marked non-null but is null");
        }
        return a.compareTo(b) < 0;
    }

    public static <T extends Comparable<T>> boolean lte(@NonNull T a, @NonNull T b) {
        if (a == null) {
            throw new NullPointerException("a is marked non-null but is null");
        }
        if (b == null) {
            throw new NullPointerException("b is marked non-null but is null");
        }
        return a.compareTo(b) <= 0;
    }

    public static <T extends Comparable<T>> boolean gt(@NonNull T a, @NonNull T b) {
        if (a == null) {
            throw new NullPointerException("a is marked non-null but is null");
        }
        if (b == null) {
            throw new NullPointerException("b is marked non-null but is null");
        }
        return a.compareTo(b) > 0;
    }

    public static <T extends Comparable<T>> boolean gte(@NonNull T a, @NonNull T b) {
        if (a == null) {
            throw new NullPointerException("a is marked non-null but is null");
        }
        if (b == null) {
            throw new NullPointerException("b is marked non-null but is null");
        }
        return a.compareTo(b) >= 0;
    }

    public static <T extends Comparable<T>> boolean eq(@NonNull T a, @NonNull T b) {
        if (a == null) {
            throw new NullPointerException("a is marked non-null but is null");
        }
        if (b == null) {
            throw new NullPointerException("b is marked non-null but is null");
        }
        return a.compareTo(b) == 0;
    }

    public static <T extends Comparable<T>> boolean between(@NonNull T a, @NonNull T start, @NonNull T end) {
        if (a == null) {
            throw new NullPointerException("a is marked non-null but is null");
        }
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        if (end == null) {
            throw new NullPointerException("end is marked non-null but is null");
        }
        return CompareAdvice.gte(a, start) && CompareAdvice.lte(a, end);
    }

    public static <T extends Comparable<T>> T max(@NonNull T a, @NonNull T b) {
        if (a == null) {
            throw new NullPointerException("a is marked non-null but is null");
        }
        if (b == null) {
            throw new NullPointerException("b is marked non-null but is null");
        }
        return CompareAdvice.gt(a, b) ? a : b;
    }

    public static <T extends Comparable<T>> T min(@NonNull T a, @NonNull T b) {
        if (a == null) {
            throw new NullPointerException("a is marked non-null but is null");
        }
        if (b == null) {
            throw new NullPointerException("b is marked non-null but is null");
        }
        return CompareAdvice.lt(a, b) ? a : b;
    }
}

