/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.utils;

import develop.toolkit.base.struct.KeyValuePairs;
import develop.toolkit.base.utils.JavaBeanUtils;
import java.lang.reflect.Field;
import lombok.NonNull;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.MethodUtils;

public final class ObjectAdvice {
    public static boolean isPrimitiveType(Class<?> clazz) {
        return ObjectAdvice.valueIn(clazz, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, Boolean.TYPE, Boolean.class, Character.TYPE, Character.class, Short.TYPE, Short.class, Byte.TYPE, Byte.class);
    }

    public static boolean isByte(Object obj) {
        Class<?> clazz = obj.getClass();
        return clazz == Byte.TYPE || clazz == Byte.class;
    }

    public static boolean isShort(Object obj) {
        Class<?> clazz = obj.getClass();
        return clazz == Short.TYPE || clazz == Short.class;
    }

    public static boolean isInt(Object obj) {
        Class<?> clazz = obj.getClass();
        return clazz == Integer.TYPE || clazz == Integer.class;
    }

    public static boolean isLong(Object obj) {
        Class<?> clazz = obj.getClass();
        return clazz == Long.TYPE || clazz == Long.class;
    }

    public static boolean isFloat(Object obj) {
        Class<?> clazz = obj.getClass();
        return clazz == Float.TYPE || clazz == Float.class;
    }

    public static boolean isDouble(Object obj) {
        Class<?> clazz = obj.getClass();
        return clazz == Double.TYPE || clazz == Double.class;
    }

    public static boolean isChar(Object obj) {
        Class<?> clazz = obj.getClass();
        return clazz == Character.TYPE || clazz == Character.class;
    }

    public static boolean isBoolean(Object obj) {
        Class<?> clazz = obj.getClass();
        return clazz == Boolean.TYPE || clazz == Boolean.class;
    }

    @SafeVarargs
    public static <T> boolean valueIn(@NonNull T obj, T ... targets) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        for (T target : targets) {
            if (!obj.equals(target)) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public static <T> boolean valueNotIn(@NonNull T obj, T ... targets) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        for (T target : targets) {
            if (!obj.equals(target)) continue;
            return false;
        }
        return true;
    }

    public static void set(Object instance, String field, Object value, boolean firstUseSetterMethod) {
        if (firstUseSetterMethod) {
            try {
                String setterMethodName = JavaBeanUtils.getSetterMethodName(field);
                MethodUtils.invokeMethod((Object)instance, (boolean)true, (String)setterMethodName);
            }
            catch (NoSuchMethodException e) {
                FieldUtils.writeDeclaredField((Object)instance, (String)field, (Object)value, (boolean)true);
            }
        } else {
            FieldUtils.writeDeclaredField((Object)instance, (String)field, (Object)value, (boolean)true);
        }
    }

    public static Object get(Object instance, String field, Class<?> fieldType, boolean firstUseGetterMethod) {
        if (firstUseGetterMethod) {
            try {
                String getterMethodName = JavaBeanUtils.getGetterMethodName(field, fieldType);
                return MethodUtils.invokeMethod((Object)instance, (boolean)true, (String)getterMethodName);
            }
            catch (NoSuchMethodException e) {
                return FieldUtils.readDeclaredField((Object)instance, (String)field, (boolean)true);
            }
        }
        return FieldUtils.readDeclaredField((Object)instance, (String)field, (boolean)true);
    }

    public static KeyValuePairs<String, Object> readAllFieldValue(Object instance) {
        Field[] fields;
        Class<?> instanceClass = instance.getClass();
        KeyValuePairs<String, Object> keyValuePairs = new KeyValuePairs<String, Object>();
        for (Field field : fields = instanceClass.getDeclaredFields()) {
            keyValuePairs.addKeyValue(field.getName(), ObjectAdvice.get(instance, field.getName(), field.getType(), true));
        }
        return keyValuePairs;
    }

    public static <T> T newInstanceQuietly(Class<T> clazz) {
        return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public static Object primitiveTypeCast(String value, Class<?> clazz) {
        if (value == null) {
            return null;
        }
        if (clazz == String.class) {
            return value;
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return Integer.parseInt(value);
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return Long.parseLong(value);
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return Boolean.parseBoolean(value);
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return Double.parseDouble(value);
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return Short.parseShort(value);
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            return Character.valueOf(value.charAt(0));
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return Byte.parseByte(value);
        }
        throw new ClassCastException();
    }
}

