/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.utils;

import develop.toolkit.base.struct.HttpAdviceResponse;
import develop.toolkit.base.utils.K;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpAdvice {
    private static final Logger log = LoggerFactory.getLogger(HttpAdvice.class);

    public static HttpClient defaultHttpClient() {
        return HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).connectTimeout(Duration.ofSeconds(5L)).followRedirects(HttpClient.Redirect.NORMAL).build();
    }

    public static HttpAdviceResponse request(String label, HttpClient httpClient, String httpMethod, String url, Map<String, String> headers, Map<String, Object> parameters, String content) throws IOException {
        return HttpAdvice.send(label, httpClient, httpMethod, HttpAdvice.builder(url, headers, parameters), content);
    }

    public static HttpAdviceResponse get(String label, HttpClient httpClient, String url, Map<String, String> headers, Map<String, Object> parameters) throws IOException {
        return HttpAdvice.send(label, httpClient, "GET", HttpAdvice.builder(url, headers, parameters), null);
    }

    public static HttpAdviceResponse post(String label, HttpClient httpClient, String url, Map<String, String> headers, String content) throws IOException {
        return HttpAdvice.send(label, httpClient, "POST", HttpAdvice.builder(url, headers, null), content);
    }

    public static HttpAdviceResponse put(String label, HttpClient httpClient, String url, Map<String, String> headers, String content) throws IOException {
        return HttpAdvice.send(label, httpClient, "PUT", HttpAdvice.builder(url, headers, null), content);
    }

    public static HttpAdviceResponse delete(String label, HttpClient httpClient, String url, Map<String, String> headers, String content) throws IOException {
        return HttpAdvice.send(label, httpClient, "DELETE", HttpAdvice.builder(url, headers, null), content);
    }

    public static HttpAdviceResponse sendFormUrlencoded(String label, HttpClient httpClient, String httpMethod, String url, Map<String, String> headers, Map<String, Object> parameters, Map<String, String> form) throws IOException {
        return HttpAdvice.send(label, httpClient, httpMethod, HttpAdvice.builder(url, headers, parameters).header("Content-Type", "application/x-www-form-urlencoded"), form.entrySet().stream().map(kv -> String.format("%s=%s", kv.getKey(), kv.getValue())).collect(Collectors.joining("&")));
    }

    public static HttpAdviceResponse sendJson(String label, HttpClient httpClient, String httpMethod, String url, Map<String, String> headers, Map<String, Object> parameters, String json) throws IOException {
        return HttpAdvice.send(label, httpClient, httpMethod, HttpAdvice.builder(url, headers, parameters).header("Content-Type", "application/json;charset=UTF-8"), json);
    }

    public static HttpAdviceResponse sendXml(String label, HttpClient httpClient, String httpMethod, String url, Map<String, String> headers, Map<String, Object> parameters, String xml) throws IOException {
        return HttpAdvice.send(label, httpClient, httpMethod, HttpAdvice.builder(url, headers, parameters).header("Content-Type", "application/xml;charset=UTF-8"), xml);
    }

    private static HttpRequest.Builder builder(String url, Map<String, String> headers, Map<String, Object> parameters) {
        if (parameters != null) {
            url = (String)url + parameters.entrySet().stream().map(kv -> String.format("%s=%s", kv.getKey(), kv.getValue())).collect(Collectors.joining("&", "?", ""));
        }
        HttpRequest.Builder builder = HttpRequest.newBuilder().version(HttpClient.Version.HTTP_1_1).uri(URI.create((String)url));
        if (headers != null) {
            headers.forEach(builder::header);
        }
        return builder;
    }

    private static HttpAdviceResponse send(String label, HttpClient httpClient, String httpMethod, HttpRequest.Builder builder, String content) throws IOException {
        HttpAdviceResponse httpAdviceResponse;
        HttpAdviceResponse response = null;
        HttpRequest httpRequest = null;
        try {
            httpRequest = builder.method(httpMethod, content == null ? HttpRequest.BodyPublishers.noBody() : HttpRequest.BodyPublishers.ofString(content, StandardCharsets.UTF_8)).timeout(Duration.ofSeconds(10L)).build();
            Instant start = Instant.now();
            HttpResponse<byte[]> httpResponse = K.def(httpClient, HttpAdvice::defaultHttpClient).send(httpRequest, HttpResponse.BodyHandlers.ofByteArray());
            Instant end = Instant.now();
            httpAdviceResponse = response = new HttpAdviceResponse(httpResponse.statusCode(), httpResponse.headers().map(), httpResponse.body(), start.until(end, ChronoUnit.MILLIS));
        }
        catch (InterruptedException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                if (log.isDebugEnabled() && httpRequest != null) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("\nlabel: ").append(label).append("\nhttp request:\n    url: ").append(httpRequest.uri().toString()).append("\n    headers:\n");
                    httpRequest.headers().map().forEach((k, v) -> sb.append("        ").append((String)k).append(": ").append(StringUtils.join((Iterable)v, (String)";")).append("\n"));
                    sb.append("    body: ").append(content != null ? content : "(no content)").append("\n");
                    if (response != null) {
                        sb.append(response.toString());
                    }
                    log.debug(sb.toString());
                }
                throw throwable;
            }
        }
        if (log.isDebugEnabled() && httpRequest != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("\nlabel: ").append(label).append("\nhttp request:\n    url: ").append(httpRequest.uri().toString()).append("\n    headers:\n");
            httpRequest.headers().map().forEach((k, v) -> sb.append("        ").append((String)k).append(": ").append(StringUtils.join((Iterable)v, (String)";")).append("\n"));
            sb.append("    body: ").append(content != null ? content : "(no content)").append("\n");
            if (response != null) {
                sb.append(response.toString());
            }
            log.debug(sb.toString());
        }
        return httpAdviceResponse;
    }
}

