/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.utils;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

public final class IOAdvice {
    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] toByteArray(InputStream inputStream) {
        try (InputStream inputStream2 = inputStream;){
            byte[] byArray;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                inputStream.transferTo(baos);
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] toByteArrayFromClasspath(String filename) {
        return IOAdvice.toByteArray(IOAdvice.readInputStreamFromClasspath(filename));
    }

    public static Stream<String> readLines(String filename) {
        return IOAdvice.readLines(filename, null);
    }

    public static Stream<String> readLines(String filename, Charset charset) {
        try {
            return IOAdvice.readLines(new FileInputStream(filename), charset);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static Stream<String> readLines(InputStream inputStream) {
        return IOAdvice.readLines(inputStream, null);
    }

    public static Stream<String> readLines(InputStream inputStream, Charset charset) {
        Stream<String> stream;
        block9: {
            InputStream inputStream2 = inputStream;
            try {
                Scanner scanner = new Scanner(inputStream, charset == null ? StandardCharsets.UTF_8 : charset);
                LinkedList<String> lines = new LinkedList<String>();
                while (scanner.hasNext()) {
                    lines.add(scanner.nextLine());
                }
                scanner.close();
                stream = lines.stream();
                if (inputStream2 == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream2 != null) {
                        try {
                            inputStream2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            inputStream2.close();
        }
        return stream;
    }

    public static InputStream readInputStreamFromClasspath(String filename) {
        return IOAdvice.class.getResourceAsStream((String)(filename.startsWith("/") ? filename : "/" + filename));
    }

    public static Stream<String> readLinesFromClasspath(String filename, Charset charset) {
        return IOAdvice.readLines(IOAdvice.readInputStreamFromClasspath(filename), charset);
    }

    public static Stream<String> readLinesFromClasspath(String filename) {
        return IOAdvice.readLines(IOAdvice.readInputStreamFromClasspath(filename), null);
    }

    public static Stream<String[]> splitFromClasspath(String filename, String regex) {
        return IOAdvice.readLinesFromClasspath(filename).map(line -> line.split(regex));
    }

    public static String readText(InputStream inputStream, Charset charset) {
        StringBuilder sb = new StringBuilder();
        IOAdvice.readLines(inputStream, charset).forEach(line -> sb.append(line.trim()));
        return sb.toString();
    }

    public static String readText(InputStream inputStream) {
        StringBuilder sb = new StringBuilder();
        IOAdvice.readLines(inputStream).forEach(line -> sb.append(line.trim()));
        return sb.toString();
    }

    public static String readTextFromClasspath(String filename, Charset charset) {
        StringBuilder sb = new StringBuilder();
        IOAdvice.forEachFromClasspath(filename, charset, line -> sb.append(line.trim()));
        return sb.toString();
    }

    public static String readTextFromClasspath(String filename) {
        StringBuilder sb = new StringBuilder();
        IOAdvice.forEachFromClasspath(filename, line -> sb.append(line.trim()));
        return sb.toString();
    }

    public static void forEach(InputStream inputStream, Charset charset, Consumer<String> consumer) {
        IOAdvice.readLines(inputStream, charset).forEach(consumer);
    }

    public static void forEach(InputStream inputStream, Consumer<String> consumer) {
        IOAdvice.readLines(inputStream).forEach(consumer);
    }

    public static void forEachFromClasspath(String filename, Charset charset, Consumer<String> consumer) {
        IOAdvice.readLinesFromClasspath(filename, charset).forEach(consumer);
    }

    public static void forEachFromClasspath(String filename, Consumer<String> consumer) {
        IOAdvice.readLinesFromClasspath(filename).forEach(consumer);
    }

    public static void writeLines(List<String> lines, String filename, Charset charset) {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), charset));){
            for (String line : lines) {
                writer.write(line);
                writer.newLine();
            }
            writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeLines(List<String> lines, OutputStream outputStream, Charset charset) {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, charset));){
            for (String line : lines) {
                writer.write(line);
                writer.newLine();
            }
            writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void appendLines(List<String> lines, String filename, Charset charset) {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), charset));){
            for (String line : lines) {
                writer.append(line);
                writer.newLine();
            }
            writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void appendLines(List<String> lines, OutputStream outputStream, Charset charset) {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, charset));){
            for (String line : lines) {
                writer.append(line);
                writer.newLine();
            }
            writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void copyText(InputStream inputStream, OutputStream outputStream, Charset charset, Function<String, String> function) {
        Scanner scanner = new Scanner(inputStream, charset);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, charset));){
            while (scanner.hasNext()) {
                String line = function.apply(scanner.nextLine());
                writer.write(line);
                writer.newLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        scanner.close();
    }

    public static long copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        long count = 0L;
        while (-1 != (n = inputStream.read(buffer))) {
            outputStream.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static long copyQuietly(File source, File target) {
        if (target.getParentFile().mkdirs()) {
            try (FileInputStream inputStream = new FileInputStream(source);){
                long l;
                try (FileOutputStream outputStream = new FileOutputStream(target);){
                    l = IOAdvice.copy(inputStream, outputStream);
                }
                return l;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return -1L;
    }

    public static void printFile(String filename, Charset charset) {
        IOAdvice.readLines(filename, charset).forEach(System.out::println);
    }

    public static void printInputStream(InputStream inputStream, Charset charset) {
        IOAdvice.readLines(inputStream, charset).forEach(System.out::println);
    }

    public static void printInputStream(InputStream inputStream) {
        IOAdvice.readLines(inputStream, StandardCharsets.UTF_8).forEach(System.out::println);
    }
}

