/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.struct;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import lombok.NonNull;

public abstract class AbstractCollectionInMap<K, V, COLLECTION extends Collection<V>>
extends LinkedHashMap<K, COLLECTION> {
    protected final Supplier<COLLECTION> supplier;

    public AbstractCollectionInMap(Supplier<COLLECTION> supplier) {
        this.supplier = supplier;
    }

    public final void putItem(K key, V item) {
        this.getInternal(key).add(item);
    }

    public final void putAllItem(K key, @NonNull Set<V> items) {
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        this.getInternal(key).addAll(items);
    }

    private COLLECTION getInternal(K key) {
        Collection collection = (Collection)this.get(key);
        if (collection == null) {
            collection = (Collection)this.supplier.get();
            this.put(key, collection);
        }
        return (COLLECTION)collection;
    }

    public final void removeItem(K key, V item) {
        Collection collection = (Collection)this.get(key);
        if (collection == null) {
            throw new IllegalStateException("key \"" + key + "\" is not exist.");
        }
        collection.remove(item);
    }

    public final void removeIfItem(K key, @NonNull Predicate<? super V> filter) {
        if (filter == null) {
            throw new NullPointerException("filter is marked non-null but is null");
        }
        Collection collection = (Collection)this.get(key);
        if (collection == null) {
            throw new IllegalStateException("key \"" + key + "\" is not exist.");
        }
        collection.removeIf(filter);
    }
}

