/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.struct;

import develop.toolkit.base.struct.KeyValuePair;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class KeyValuePairs<K, V>
extends LinkedList<KeyValuePair<K, V>> {
    private static final long serialVersionUID = -3327179013671312416L;

    public void addKeyValue(K key, V value) {
        this.add(new KeyValuePair<K, V>(key, value));
    }

    public List<K> allKey() {
        return this.stream().map(KeyValuePair::getKey).collect(Collectors.toList());
    }

    public List<V> allValue() {
        return this.stream().map(KeyValuePair::getValue).collect(Collectors.toList());
    }

    public Map<K, V> toMap() {
        HashMap map = new HashMap();
        this.forEach(kv -> map.put(kv.getKey(), kv.getValue()));
        return map;
    }

    public static <K, V> KeyValuePairs<K, V> fromMap(Map<K, V> map) {
        KeyValuePairs<K, V> keyValuePairs = new KeyValuePairs<K, V>();
        map.forEach(keyValuePairs::addKeyValue);
        return keyValuePairs;
    }

    @SafeVarargs
    public static <K, V> KeyValuePairs<K, V> of(KeyValuePair<K, V> ... keyValuePairArray) {
        return KeyValuePairs.of(List.of(keyValuePairArray));
    }

    public static <K, V> KeyValuePairs<K, V> of(Collection<KeyValuePair<K, V>> keyValuePairCollection) {
        KeyValuePairs<K, V> keyValuePairs = new KeyValuePairs<K, V>();
        keyValuePairs.addAll(keyValuePairCollection);
        return keyValuePairs;
    }
}

