/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.struct.http;

import develop.toolkit.base.utils.IOAdvice;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public final class HttpClientReceiver<T> {
    private final int httpStatus;
    private final Map<String, List<String>> headers;
    private final T body;
    private final long costTime;

    public String getHeader(String header) {
        return StringUtils.join((Iterable)this.headers.getOrDefault(header, List.of()), (String)";");
    }

    public boolean isSuccess() {
        return this.httpStatus >= 200 && this.httpStatus < 300;
    }

    public void save(Path path, OpenOption ... openOptions) {
        byte[] data;
        if (this.body instanceof InputStream) {
            data = IOAdvice.toByteArray((InputStream)this.body);
        } else if (this.body.getClass().isArray()) {
            data = (byte[])this.body;
        } else if (this.body instanceof String) {
            data = ((String)this.body).getBytes();
        } else {
            throw new IllegalArgumentException();
        }
        try {
            Files.write(path, data, openOptions);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getHttpStatus() {
        return this.httpStatus;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public T getBody() {
        return this.body;
    }

    public long getCostTime() {
        return this.costTime;
    }

    public HttpClientReceiver(int httpStatus, Map<String, List<String>> headers, T body, long costTime) {
        this.httpStatus = httpStatus;
        this.headers = headers;
        this.body = body;
        this.costTime = costTime;
    }
}

