/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.base.struct.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import org.apache.commons.lang3.RandomStringUtils;

public class MultiPartFormDataBody {
    private final List<PartsSpecification> partsSpecificationList = new ArrayList<PartsSpecification>();
    private final String boundary = RandomStringUtils.randomAlphabetic((int)10);

    public HttpRequest.BodyPublisher buildBodyPublisher() {
        if (this.partsSpecificationList.isEmpty()) {
            throw new IllegalStateException("Must have at least one part to build multipart message.");
        }
        this.addFinalBoundaryPart();
        return HttpRequest.BodyPublishers.ofByteArrays(() -> new PartsIterator());
    }

    public MultiPartFormDataBody addPart(String name, String value) {
        PartsSpecification newPart = new PartsSpecification();
        newPart.type = PartsSpecification.Type.STRING;
        newPart.name = name;
        newPart.value = value;
        this.partsSpecificationList.add(newPart);
        return this;
    }

    public MultiPartFormDataBody addPart(String name, Path path) {
        PartsSpecification newPart = new PartsSpecification();
        newPart.type = PartsSpecification.Type.FILE;
        newPart.name = name;
        newPart.path = path;
        this.partsSpecificationList.add(newPart);
        return this;
    }

    public MultiPartFormDataBody addPart(String name, byte[] bytes) {
        PartsSpecification newPart = new PartsSpecification();
        newPart.type = PartsSpecification.Type.FILE;
        newPart.name = name;
        newPart.bytes = bytes;
        this.partsSpecificationList.add(newPart);
        return this;
    }

    public MultiPartFormDataBody addPart(String name, String filename, String contentType, Supplier<InputStream> stream) {
        PartsSpecification newPart = new PartsSpecification();
        newPart.type = PartsSpecification.Type.STREAM;
        newPart.name = name;
        newPart.stream = stream;
        newPart.filename = filename;
        newPart.contentType = contentType;
        this.partsSpecificationList.add(newPart);
        return this;
    }

    private void addFinalBoundaryPart() {
        PartsSpecification newPart = new PartsSpecification();
        newPart.type = PartsSpecification.Type.FINAL_BOUNDARY;
        newPart.value = "--" + this.boundary + "--";
        this.partsSpecificationList.add(newPart);
    }

    public String getBoundary() {
        return this.boundary;
    }

    class PartsIterator
    implements Iterator<byte[]> {
        private final Iterator<PartsSpecification> iterator;
        private InputStream currentFileInput;
        private boolean done;
        private byte[] next;
        private static final String NEW_LINE = "\r\n";

        PartsIterator() {
            this.iterator = MultiPartFormDataBody.this.partsSpecificationList.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.done) {
                return false;
            }
            if (this.next != null) {
                return true;
            }
            try {
                this.next = this.computeNext();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            if (this.next == null) {
                this.done = true;
                return false;
            }
            return true;
        }

        @Override
        public byte[] next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            byte[] res = this.next;
            this.next = null;
            return res;
        }

        private byte[] computeNext() throws IOException {
            if (this.currentFileInput == null) {
                if (!this.iterator.hasNext()) {
                    return null;
                }
                PartsSpecification nextPart = this.iterator.next();
                String filename = null;
                String contentType = "application/octet-stream";
                switch (nextPart.type) {
                    case STRING: {
                        return this.headerBytes(nextPart.name, nextPart.value, null, "text/plain; charset=UTF-8");
                    }
                    case FINAL_BOUNDARY: {
                        return nextPart.value.getBytes(StandardCharsets.UTF_8);
                    }
                    case BYTES: {
                        return nextPart.bytes;
                    }
                    case FILE: {
                        Path path = nextPart.path;
                        filename = path.getFileName().toString();
                        contentType = Files.probeContentType(path);
                        this.currentFileInput = Files.newInputStream(path, new OpenOption[0]);
                        break;
                    }
                    case STREAM: {
                        filename = nextPart.filename;
                        contentType = nextPart.contentType;
                        this.currentFileInput = nextPart.stream.get();
                    }
                }
                return this.headerBytes(nextPart.name, null, filename, contentType);
            }
            byte[] buf = new byte[8192];
            int r = this.currentFileInput.read(buf);
            if (r > 0) {
                byte[] actualBytes = new byte[r];
                System.arraycopy(buf, 0, actualBytes, 0, r);
                return actualBytes;
            }
            this.currentFileInput.close();
            this.currentFileInput = null;
            return NEW_LINE.getBytes();
        }

        private byte[] headerBytes(String name, String value, String filename, String contentType) {
            StringBuilder sb = new StringBuilder("--").append(MultiPartFormDataBody.this.boundary).append(NEW_LINE).append("Content-Disposition: form-data; name=").append(name);
            if (filename != null) {
                sb.append("; filename=").append(filename);
            }
            sb.append(NEW_LINE).append("Content-Type: ").append(contentType).append(NEW_LINE).append(NEW_LINE);
            if (value != null) {
                sb.append(value).append(NEW_LINE);
            }
            return sb.toString().getBytes(StandardCharsets.UTF_8);
        }
    }

    static class PartsSpecification {
        public Type type;
        public String name;
        public String value;
        public Path path;
        public byte[] bytes;
        public Supplier<InputStream> stream;
        public String filename;
        public String contentType;

        PartsSpecification() {
        }

        public static enum Type {
            STRING,
            FILE,
            BYTES,
            STREAM,
            FINAL_BOUNDARY;

        }
    }
}

