/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.db.mysql;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class MysqlProperties {
    private final String domain;
    private final int port;
    private final String username;
    private final String password;
    private final String database;
    private final Map<String, String> parameters = new HashMap<String, String>();

    public MysqlProperties(String domain, int port, String username, String password, String database) {
        this.domain = domain;
        this.port = port;
        this.username = username;
        this.password = password;
        this.database = database;
        this.parameters.put("useSSL", "false");
        this.parameters.put("serverTimezone", "Asia/Shanghai");
    }

    public String getUrl() {
        return String.format("jdbc:mysql://%s:%d/%s?", this.domain, this.port, this.database) + this.parameters.entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining("&"));
    }

    public String getDomain() {
        return this.domain;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDatabase() {
        return this.database;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }
}

