/*
 * Decompiled with CFR 0.152.
 */
package develop.toolkit.db.mysql;

import com.github.developframework.expression.ExpressionUtils;
import develop.toolkit.base.utils.JavaBeanUtils;
import develop.toolkit.base.utils.K;
import develop.toolkit.db.mysql.MysqlProperties;
import develop.toolkit.db.mysql.NoUniqueResultException;
import develop.toolkit.db.mysql.PreparedStatementSetter;
import develop.toolkit.db.mysql.RowMapper;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class MysqlClient
implements AutoCloseable {
    private final Connection connection;

    public MysqlClient(MysqlProperties mysqlProperties) throws SQLException {
        try {
            Class.forName("com.mysql.cj.jdbc.Driver");
            this.connection = DriverManager.getConnection(mysqlProperties.getUrl(), mysqlProperties.getUsername(), mysqlProperties.getPassword());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> List<T> query(String sql, RowMapper<T> rowMapper) throws SQLException {
        return this.query(sql, null, rowMapper);
    }

    public <T> List<T> query(String sql, PreparedStatementSetter setter, RowMapper<T> rowMapper) throws SQLException {
        PreparedStatement statement = this.connection.prepareStatement(sql);
        if (setter != null) {
            setter.set(statement);
        }
        ResultSet resultSet = statement.executeQuery();
        try (PreparedStatement preparedStatement = statement;){
            List list;
            block14: {
                ResultSet resultSet2 = resultSet;
                try {
                    LinkedList<T> list2 = new LinkedList<T>();
                    while (resultSet.next()) {
                        list2.add(rowMapper.mapping(resultSet));
                    }
                    list = Collections.unmodifiableList(list2);
                    if (resultSet2 == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resultSet2 != null) {
                        try {
                            resultSet2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet2.close();
            }
            return list;
        }
    }

    public <T> Optional<T> queryOne(String sql, RowMapper<T> rowMapper) throws SQLException {
        List<T> list = this.query(sql, rowMapper);
        if (list.size() > 1) {
            throw new NoUniqueResultException(list.size());
        }
        return Optional.ofNullable(list.isEmpty() ? null : (Object)list.get(0));
    }

    public <T> Optional<T> queryOne(String sql, PreparedStatementSetter setter, RowMapper<T> rowMapper) throws SQLException {
        List<T> list = this.query(sql, setter, rowMapper);
        if (list.size() > 1) {
            throw new NoUniqueResultException(list.size());
        }
        return Optional.ofNullable(list.isEmpty() ? null : (Object)list.get(0));
    }

    public <T> int insertAll(String table, Collection<T> collection, String ... fields) throws SQLException {
        String sql = "INSERT INTO " + table + "(" + Stream.of(fields).map(f -> String.format("`%s`", f)).collect(Collectors.joining(",")) + ") VALUES" + collection.stream().map(data -> Stream.of(fields).map(field -> {
            String value = (String)K.map((Object)ExpressionUtils.getValue((Object)data, (String)JavaBeanUtils.underlineToCamelcase((String)field)), Object::toString);
            return StringUtils.isNumeric((CharSequence)value) ? value : "'" + value + "'";
        }).collect(Collectors.joining(",", "(", ")"))).collect(Collectors.joining(","));
        try (Statement statement = this.connection.createStatement();){
            int n = statement.executeUpdate(sql);
            return n;
        }
    }

    public <T> int insert(String table, T data, String ... fields) throws SQLException {
        return this.insertAll(table, List.of(data), fields);
    }

    public int executeUpdate(String sql, PreparedStatementSetter setter) throws SQLException {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(sql);){
            if (setter != null) {
                setter.set(preparedStatement);
            }
            int n = preparedStatement.executeUpdate();
            return n;
        }
    }

    public int executeUpdate(String sql) throws SQLException {
        return this.executeUpdate(sql, null);
    }

    @Override
    public void close() throws SQLException {
        this.connection.close();
    }

    public Connection getConnection() {
        return this.connection;
    }
}

