/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.boot;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.developframework.kite.boot.KiteProperties;
import com.github.developframework.kite.boot.KiteWebMvcConfigurer;
import com.github.developframework.kite.core.KiteConfiguration;
import com.github.developframework.kite.core.KiteFactory;
import com.github.developframework.kite.core.exception.KiteException;
import com.github.developframework.kite.core.strategy.DoNothingKitePropertyNamingStrategy;
import com.github.developframework.kite.core.strategy.KitePropertyNamingStrategy;
import com.github.developframework.kite.spring.KiteScanLoader;
import com.github.developframework.kite.spring.mvc.DataModelReturnValueHandler;
import com.github.developframework.kite.spring.mvc.KiteResponseReturnValueHandler;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={KiteWebMvcConfigurer.class})
@AutoConfigureAfter(value={JacksonAutoConfiguration.class})
public class KiteComponentAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(KiteComponentAutoConfiguration.class);

    @Bean
    @Autowired
    @ConditionalOnProperty(name={"kite.json.useDefault"}, havingValue="true", matchIfMissing=true)
    public KiteFactory kiteFactoryForDefaultObjectMapper(KiteProperties kiteProperties, ObjectMapper objectMapper) {
        log.info("Kite framework use Jackson default ObjectMapper.");
        KiteScanLoader loader = new KiteScanLoader(kiteProperties.getLocations());
        KiteFactory kiteFactory = loader.createKiteFactory(objectMapper);
        this.configKiteConfiguration(kiteFactory.getKiteConfiguration(), kiteProperties);
        return kiteFactory;
    }

    @Bean
    @ConditionalOnProperty(name={"kite.json.useDefault"}, havingValue="false")
    public KiteFactory kiteFactoryForNewObjectMapper(KiteProperties kiteProperties) {
        log.info("Kite framework use a new ObjectMapper.");
        KiteScanLoader loader = new KiteScanLoader(kiteProperties.getLocations());
        KiteFactory kiteFactory = loader.createKiteFactory();
        this.configKiteConfiguration(kiteFactory.getKiteConfiguration(), kiteProperties);
        return kiteFactory;
    }

    @Bean
    public DataModelReturnValueHandler dataModelReturnValueHandler(KiteFactory kiteFactory) {
        return new DataModelReturnValueHandler(kiteFactory);
    }

    @Bean
    public KiteResponseReturnValueHandler kiteResponseReturnValueHandler(KiteFactory kiteFactory) {
        return new KiteResponseReturnValueHandler(kiteFactory);
    }

    private void configKiteConfiguration(KiteConfiguration kiteConfiguration, KiteProperties kiteProperties) {
        String jsonNamingStrategy = kiteProperties.getJson() == null ? null : kiteProperties.getJson().getNamingStrategy();
        String xmlNamingStrategy = kiteProperties.getXml() == null ? null : kiteProperties.getXml().getNamingStrategy();
        kiteConfiguration.setForJsonStrategy(this.getKitePropertyNamingStrategy(jsonNamingStrategy));
        log.info("The \"{}\" is activate on JsonProducer.", (Object)kiteConfiguration.getForJsonStrategy().getClass().getSimpleName());
        kiteConfiguration.setForXmlStrategy(this.getKitePropertyNamingStrategy(xmlNamingStrategy));
        log.info("The \"{}\" is activate on XmlProducer.", (Object)kiteConfiguration.getForXmlStrategy().getClass().getSimpleName());
        if (kiteProperties.getXml() != null && kiteProperties.getXml().getSuppressDeclaration() != null) {
            kiteConfiguration.setXmlSuppressDeclaration(kiteProperties.getXml().getSuppressDeclaration().booleanValue());
        }
    }

    private KitePropertyNamingStrategy getKitePropertyNamingStrategy(String namingStrategyValue) {
        if (StringUtils.isNotBlank((CharSequence)namingStrategyValue)) {
            if (namingStrategyValue.toLowerCase().equals("doNothing")) {
                return new DoNothingKitePropertyNamingStrategy();
            }
            try {
                Class<?> namingStrategyClass = Class.forName(namingStrategyValue);
                if (KitePropertyNamingStrategy.class.isAssignableFrom(namingStrategyClass)) {
                    return (KitePropertyNamingStrategy)namingStrategyClass.newInstance();
                }
                throw new KiteException("Class \"%s\" is not subclass \"%s\".", new Object[]{namingStrategyValue, KitePropertyNamingStrategy.class.getName()});
            }
            catch (ClassNotFoundException e) {
                throw new KiteException("Class \"%s\" is not found.", new Object[]{namingStrategyValue});
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

