/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.spring;

import com.github.developframework.kite.core.KiteFactory;
import com.github.developframework.kite.core.element.Template;
import com.github.developframework.kite.core.exception.KiteException;
import com.github.developframework.kite.core.source.ConfigurationSource;
import com.github.developframework.kite.core.source.StringConfigurationSource;
import com.github.developframework.kite.core.structs.FragmentLocation;
import com.github.developframework.kite.core.structs.TemplatePackage;
import com.github.developframework.kite.core.structs.TemplatePackageRegistry;
import com.github.developframework.kite.spring.mvc.annotation.KiteNamespace;
import com.github.developframework.kite.spring.mvc.annotation.TemplateKTL;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public final class ControllerKtlTemplateScanner {
    private final KiteFactory kiteFactory;
    private final RequestMappingHandlerMapping handlerMapping;

    public Map<Method, FragmentLocation> scan() {
        HashMap<Method, FragmentLocation> fragmentLocationMap = new HashMap<Method, FragmentLocation>();
        this.handlerMapping.getHandlerMethods().forEach((info, handlerMethod) -> {
            List ktlTemplatePackages;
            TemplateKTL templateKTL = (TemplateKTL)handlerMethod.getMethodAnnotation(TemplateKTL.class);
            if (templateKTL == null) {
                return;
            }
            String ktl = String.join((CharSequence)"\n", templateKTL.value());
            if (ktl.isBlank()) {
                return;
            }
            try {
                ktlTemplatePackages = this.kiteFactory.getKtlParser().read((ConfigurationSource)new StringConfigurationSource(ktl, StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new KiteException("KTL\u7459\uff46\u703d\u6fb6\u8fab\u89e6");
            }
            String namespace = this.getNamespace((HandlerMethod)handlerMethod);
            TemplatePackageRegistry registry = this.kiteFactory.getConfiguration().getTemplatePackageRegistry();
            TemplatePackage ktlTemplatePackage = (TemplatePackage)ktlTemplatePackages.get(0);
            if (ktlTemplatePackage.getNamespace().equals("_default")) {
                ktlTemplatePackage.setNamespace(namespace);
                registry.mergeTemplatePackage(ktlTemplatePackage);
            }
            Template uniqueTemplate = ktlTemplatePackage.getUniqueTemplate();
            fragmentLocationMap.put(handlerMethod.getMethod(), uniqueTemplate.getFragmentLocation());
        });
        return fragmentLocationMap;
    }

    private String getNamespace(HandlerMethod handlerMethod) {
        Class controllerClass;
        KiteNamespace kiteNamespace = (KiteNamespace)handlerMethod.getMethodAnnotation(KiteNamespace.class);
        if (kiteNamespace == null && (kiteNamespace = (controllerClass = handlerMethod.getBeanType()).getAnnotation(KiteNamespace.class)) == null) {
            throw new KiteException("\u9366\u3122\ufffd\ufffd%s\u9225\u6fc7\u67df\u5a09\u66d7\ufffd\ufffd%s\u9225\u6fc5\u7b02\u5a0c\u2103\u7223\u5a09\u02caKiteNamespace\u951b\u5c7e\u57a8\u9470\u546d\u6e6aController\u7eeb\u8bb3\u7b02\u93cd\u56e8\u655e\u934f\u3125\u772c@KiteNamespace", new Object[]{controllerClass.getName(), handlerMethod.getMethod().getName()});
        }
        return kiteNamespace.value();
    }

    public ControllerKtlTemplateScanner(KiteFactory kiteFactory, RequestMappingHandlerMapping handlerMapping) {
        this.kiteFactory = kiteFactory;
        this.handlerMapping = handlerMapping;
    }
}

