/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.spring;

import com.github.developframework.kite.core.Framework;
import com.github.developframework.kite.core.KiteFactory;
import com.github.developframework.kite.core.KiteFactoryBuilder;
import com.github.developframework.kite.core.KiteOptions;
import com.github.developframework.kite.core.exception.KiteException;
import com.github.developframework.kite.spring.SpringResourceConfigurationSource;
import java.io.IOException;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.StringUtils;

public class KiteScanLoader {
    private final String locations;

    public KiteFactory createKiteFactory(Framework<?> jsonFramework, Framework<?> xmlFramework, KiteOptions options) {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        String[] locationsArray = StringUtils.tokenizeToStringArray((String)this.locations, (String)",; \t\n");
        Set sources = Stream.of(locationsArray).flatMap(arg_0 -> KiteScanLoader.lambda$createKiteFactory$0((ResourcePatternResolver)resolver, arg_0)).collect(Collectors.toSet());
        KiteFactory kiteFactory = KiteFactoryBuilder.buildFromXml((KiteOptions)options, sources);
        kiteFactory.useJsonFramework(jsonFramework);
        kiteFactory.useXmlFramework(xmlFramework);
        return kiteFactory;
    }

    public KiteScanLoader(String locations) {
        this.locations = locations;
    }

    public String getLocations() {
        return this.locations;
    }

    private static /* synthetic */ Stream lambda$createKiteFactory$0(ResourcePatternResolver resolver, String location) {
        try {
            return Stream.of(resolver.getResources(location)).map(SpringResourceConfigurationSource::new);
        }
        catch (IOException e) {
            throw new KiteException("Happen IOException when Spring ResourcePatternResolver get resource: %s", new Object[]{e.getMessage()});
        }
    }
}

