/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.spring.mvc;

import com.github.developframework.kite.core.KiteFactory;
import com.github.developframework.kite.core.Producer;
import com.github.developframework.kite.core.data.DataModel;
import com.github.developframework.kite.spring.KiteResponseBodyProcessor;
import com.github.developframework.kite.spring.mvc.annotation.TemplateType;
import java.nio.charset.Charset;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;

public abstract class AbstractKiteReturnValueHandler<T>
implements HandlerMethodReturnValueHandler {
    @Autowired
    protected KiteFactory kiteFactory;
    @Autowired(required=false)
    protected KiteResponseBodyProcessor kiteResponseBodyProcessor;

    public boolean supportsReturnType(MethodParameter returnType) {
        return this.returnType().isAssignableFrom(returnType.getParameterType());
    }

    public void handleReturnValue(Object returnValue, MethodParameter methodParameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        Assert.isInstanceOf(this.returnType(), (Object)returnValue);
        mavContainer.setRequestHandled(true);
        Object t = returnValue;
        String namespace = this.namespace(t, methodParameter);
        String templateId = this.templateId(t, methodParameter);
        TemplateType templateType = this.templateType(t, methodParameter);
        DataModel dataModel = this.dataModel(t, methodParameter);
        Producer producer = templateType == TemplateType.JSON ? this.kiteFactory.getJsonProducer(dataModel, namespace, templateId) : this.kiteFactory.getXmlProducer(dataModel, namespace, templateId);
        String payload = producer.produce(false);
        if (this.kiteResponseBodyProcessor != null) {
            this.kiteResponseBodyProcessor.beforeWrite(methodParameter, webRequest, payload);
        }
        ServletServerHttpResponse outputMessage = this.createOutputMessage(webRequest, templateType);
        Charset charset = outputMessage.getHeaders().getContentType().getCharset();
        producer.output(outputMessage.getBody(), charset, false);
    }

    private ServletServerHttpResponse createOutputMessage(NativeWebRequest webRequest, TemplateType templateType) {
        HttpServletResponse response = (HttpServletResponse)webRequest.getNativeResponse(HttpServletResponse.class);
        Assert.state((response != null ? 1 : 0) != 0, (String)"No HttpServletResponse");
        ServletServerHttpResponse res = new ServletServerHttpResponse(response);
        HttpHeaders headers = res.getHeaders();
        if (headers.getContentType() == null) {
            headers.setContentType(templateType == TemplateType.JSON ? MediaType.APPLICATION_JSON_UTF8 : MediaType.APPLICATION_XML);
        }
        return res;
    }

    protected abstract Class<T> returnType();

    protected abstract String namespace(T var1, MethodParameter var2);

    protected abstract String templateId(T var1, MethodParameter var2);

    protected abstract TemplateType templateType(T var1, MethodParameter var2);

    protected abstract DataModel dataModel(T var1, MethodParameter var2);
}

