/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.spring.mvc;

import com.github.developframework.kite.core.exception.KiteException;
import com.github.developframework.kite.core.structs.FragmentLocation;
import com.github.developframework.kite.spring.mvc.AbstractKiteReturnValueHandler;
import com.github.developframework.kite.spring.mvc.annotation.KiteNamespace;
import com.github.developframework.kite.spring.mvc.annotation.TemplateId;
import com.github.developframework.kite.spring.mvc.annotation.TemplateKTL;
import com.github.developframework.kite.spring.mvc.annotation.TemplateType;
import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;

public abstract class AnnotationKiteReturnValueHandler<T>
extends AbstractKiteReturnValueHandler<T> {
    protected Map<Method, FragmentLocation> fragmentLocationMap;

    @Override
    protected String namespace(T returnValue, MethodParameter methodParameter) {
        KiteNamespace annotation = (KiteNamespace)methodParameter.getMethodAnnotation(KiteNamespace.class);
        if (annotation == null && (annotation = (KiteNamespace)AnnotationUtils.findAnnotation((Class)methodParameter.getContainingClass(), KiteNamespace.class)) == null) {
            throw new KiteException("\u9366\u3122\ufffd\ufffd%s\u9225\u6fc7\u67df\u5a09\u66d7\ufffd\ufffd%s\u9225\u6fc5\u7b02\u5a0c\u2103\u7223\u5a09\u02caKiteNamespace\u951b\u5c7e\u57a8\u9470\u546d\u6e6aController\u7eeb\u8bb3\u7b02\u93cd\u56e8\u655e\u934f\u3125\u772c@KiteNamespace", new Object[]{methodParameter.getContainingClass(), methodParameter.getMethod().getName()});
        }
        return annotation.value();
    }

    @Override
    protected String templateId(T returnValue, MethodParameter methodParameter) {
        TemplateId templateId = (TemplateId)methodParameter.getMethodAnnotation(TemplateId.class);
        if (templateId != null) {
            return templateId.value();
        }
        TemplateKTL templateKTL = (TemplateKTL)methodParameter.getMethodAnnotation(TemplateKTL.class);
        if (templateKTL == null) {
            throw new KiteException("\u9366\u3122\ufffd\ufffd%s\u9225\u6fc7\u67df\u5a09\u66d7\ufffd\ufffd%s\u9225\u6fc5\u7b02\u5a0c\u2103\u7223\u5a09\u02caTemplateId\u93b4\u6704TemplateKTL", new Object[]{methodParameter.getContainingClass(), methodParameter.getMethod().getName()});
        }
        FragmentLocation fragmentLocation = this.fragmentLocationMap.get(methodParameter.getMethod());
        return fragmentLocation.getFragmentId();
    }

    @Override
    protected TemplateType templateType(T returnValue, MethodParameter methodParameter) {
        TemplateId templateId = (TemplateId)methodParameter.getMethodAnnotation(TemplateId.class);
        if (templateId != null) {
            return templateId.type();
        }
        TemplateKTL templateKTL = (TemplateKTL)methodParameter.getMethodAnnotation(TemplateKTL.class);
        if (templateKTL == null) {
            throw new KiteException("\u9366\u3122\ufffd\ufffd%s\u9225\u6fc7\u67df\u5a09\u66d7\ufffd\ufffd%s\u9225\u6fc5\u7b02\u5a0c\u2103\u7223\u5a09\u02caTemplateId\u93b4\u6704TemplateKTL", new Object[]{methodParameter.getContainingClass(), methodParameter.getMethod().getName()});
        }
        return templateKTL.type();
    }

    public void setFragmentLocationMap(Map<Method, FragmentLocation> fragmentLocationMap) {
        this.fragmentLocationMap = fragmentLocationMap;
    }
}

