/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.resource;

import com.github.developframework.resource.AddCheckExistsLogic;
import com.github.developframework.resource.DTO;
import com.github.developframework.resource.Entity;
import com.github.developframework.resource.ModifyCheckExistsLogic;
import com.github.developframework.resource.ResourceDefinition;
import com.github.developframework.resource.ResourceHandler;
import com.github.developframework.resource.ResourceManager;
import com.github.developframework.resource.ResourceOperateRegistry;
import com.github.developframework.resource.exception.ResourceNotExistException;
import com.github.developframework.resource.operate.SearchResourceOperate;
import com.github.developframework.resource.utils.ResourceAssert;
import java.io.Serializable;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResourceManager<ENTITY extends Entity<ID>, ID extends Serializable>
implements ResourceManager<ENTITY, ID> {
    private static final Logger log = LoggerFactory.getLogger(AbstractResourceManager.class);
    protected ResourceDefinition<ENTITY> resourceDefinition;
    protected ResourceHandler<ENTITY, ID> resourceHandler;
    protected ResourceOperateRegistry<ENTITY, ID> resourceOperateRegistry;

    public AbstractResourceManager(ResourceDefinition<ENTITY> resourceDefinition) {
        this.resourceDefinition = resourceDefinition;
    }

    @Override
    public boolean existsById(ID id) {
        return this.resourceHandler.existsById(id);
    }

    @Override
    public void assertExistsById(ID id) {
        if (!this.resourceHandler.existsById(id)) {
            throw new ResourceNotExistException(this.resourceDefinition.getResourceName()).addParameter("id", id);
        }
    }

    @Override
    public Optional<ENTITY> add(Object dto) {
        return this.resourceOperateRegistry.getAddResourceOperate(dto.getClass()).addResource(dto);
    }

    @Override
    public Optional<ENTITY> modifyById(ID id, Object dto) {
        return this.resourceOperateRegistry.getModifyResourceOperate(dto.getClass()).modifyById(dto, id);
    }

    @Override
    public boolean modify(Object dto, ENTITY entity) {
        return this.resourceOperateRegistry.getModifyResourceOperate(dto.getClass()).modify(dto, entity);
    }

    @Override
    public Optional<ENTITY> removeById(ID id) {
        return this.resourceOperateRegistry.getRemoveResourceOperate().removeById(id);
    }

    @Override
    public boolean remove(ENTITY entity) {
        return this.resourceOperateRegistry.getRemoveResourceOperate().remove(entity);
    }

    @Override
    public Optional<ENTITY> findOneById(ID id) {
        return this.resourceHandler.queryById(id).map(this::execSearchOperate);
    }

    @Override
    public ENTITY findOneByIdRequired(ID id) {
        Entity entity = (Entity)ResourceAssert.resourceExistAssertBuilder(this.resourceDefinition.getResourceName(), this.resourceHandler.queryById(id)).addParameter("id", id).returnValue();
        return (ENTITY)this.execSearchOperate((Iterable)((Object)entity));
    }

    protected final ENTITY execSearchOperate(ENTITY entity) {
        SearchResourceOperate<ENTITY, ID> searchResourceOperate = this.resourceOperateRegistry.getSearchResourceOperate();
        if (searchResourceOperate != null) {
            searchResourceOperate.after(entity);
        }
        return entity;
    }

    protected final <T extends Iterable<ENTITY>> T execSearchOperate(T entities) {
        SearchResourceOperate<ENTITY, ID> searchResourceOperate = this.resourceOperateRegistry.getSearchResourceOperate();
        if (searchResourceOperate != null) {
            entities.forEach(searchResourceOperate::after);
        }
        return (T)entities;
    }

    public abstract <T extends DTO> AddCheckExistsLogic<ENTITY, T, ID> byFieldAddCheck(Class<T> var1, String ... var2);

    public abstract <T extends DTO> ModifyCheckExistsLogic<ENTITY, T, ID> byFieldModifyCheck(Class<T> var1, String ... var2);

    public ResourceDefinition<ENTITY> getResourceDefinition() {
        return this.resourceDefinition;
    }

    public ResourceHandler<ENTITY, ID> getResourceHandler() {
        return this.resourceHandler;
    }

    public ResourceOperateRegistry<ENTITY, ID> getResourceOperateRegistry() {
        return this.resourceOperateRegistry;
    }
}

