/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.resource;

import com.github.developframework.resource.AbstractResourceManager;
import com.github.developframework.resource.DTO;
import com.github.developframework.resource.DefaultRegister;
import com.github.developframework.resource.Entity;
import com.github.developframework.resource.ResourceOperate;
import com.github.developframework.resource.exception.UnRegisterOperateException;
import com.github.developframework.resource.operate.AddResourceOperate;
import com.github.developframework.resource.operate.AddUniqueResourceOperate;
import com.github.developframework.resource.operate.ModifyResourceOperate;
import com.github.developframework.resource.operate.PersistResourceOperate;
import com.github.developframework.resource.operate.RemoveResourceOperate;
import com.github.developframework.resource.operate.SearchResourceOperate;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceOperateRegistry<ENTITY extends Entity<ID>, ID extends Serializable> {
    private static final Logger log = LoggerFactory.getLogger(ResourceOperateRegistry.class);
    private AbstractResourceManager<ENTITY, ID> manager;
    private Map<Class<?>, AddResourceOperate<ENTITY, ?, ID>> addResourceOperateMap;
    private Map<Class<?>, ModifyResourceOperate<ENTITY, ?, ID>> modifyResourceOperateMap;
    protected RemoveResourceOperate<ENTITY, ID> removeResourceOperate;
    protected SearchResourceOperate<ENTITY, ID> searchResourceOperate;
    private boolean uniqueEntity;

    public ResourceOperateRegistry(AbstractResourceManager<ENTITY, ID> manager) {
        this.manager = manager;
        Class<?> managerClass = manager.getClass();
        Stream.of(managerClass.getDeclaredMethods()).filter(method -> ResourceOperate.class.isAssignableFrom(method.getReturnType()) && method.getParameterTypes().length == 0).forEach(method -> {
            method.setAccessible(true);
            try {
                ResourceOperate resourceOperate = (ResourceOperate)method.invoke((Object)manager, new Object[0]);
                resourceOperate.setManager(manager);
                if (resourceOperate instanceof AddResourceOperate) {
                    this.register((AddResourceOperate)resourceOperate);
                } else if (resourceOperate instanceof ModifyResourceOperate) {
                    this.register((ModifyResourceOperate)resourceOperate);
                } else if (resourceOperate instanceof RemoveResourceOperate) {
                    this.register((RemoveResourceOperate)resourceOperate);
                } else if (resourceOperate instanceof SearchResourceOperate) {
                    this.register((SearchResourceOperate)resourceOperate);
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        });
        if (managerClass.isAnnotationPresent(DefaultRegister.class)) {
            PersistResourceOperate resourceOperate;
            DefaultRegister annotation = managerClass.getAnnotation(DefaultRegister.class);
            if (this.addResourceOperateMap == null) {
                resourceOperate = new AddResourceOperate<ENTITY, DTO, ID>(annotation.dtoClass(), annotation.mapperClass());
                resourceOperate.setManager(manager);
                this.register((AddResourceOperate)resourceOperate);
            }
            if (this.modifyResourceOperateMap == null) {
                resourceOperate = new ModifyResourceOperate(annotation.dtoClass(), annotation.mapperClass());
                resourceOperate.setManager(manager);
                this.register((ModifyResourceOperate)resourceOperate);
            }
        }
        if (this.removeResourceOperate == null) {
            RemoveResourceOperate<ENTITY, ID> resourceOperate = new RemoveResourceOperate<ENTITY, ID>();
            resourceOperate.setManager(manager);
            this.register(resourceOperate);
        }
        this.uniqueEntity = this.addResourceOperateMap != null && this.addResourceOperateMap.values().stream().anyMatch(operate -> operate instanceof AddUniqueResourceOperate);
    }

    public <T extends DTO> void register(AddResourceOperate<ENTITY, T, ID> addResourceOperate) {
        if (this.addResourceOperateMap == null) {
            this.addResourceOperateMap = new HashMap();
        }
        this.addResourceOperateMap.put(addResourceOperate.getDtoClass(), addResourceOperate);
        log.debug("register {} for {} add operate", (Object)addResourceOperate.getDtoClass().getSimpleName(), (Object)this.manager.getResourceDefinition().getEntityClass().getSimpleName());
    }

    public <T extends DTO> void register(ModifyResourceOperate<ENTITY, T, ID> modifyResourceOperate) {
        if (this.modifyResourceOperateMap == null) {
            this.modifyResourceOperateMap = new HashMap();
        }
        this.modifyResourceOperateMap.put(modifyResourceOperate.getDtoClass(), modifyResourceOperate);
        log.debug("register {} for {} modify operate", (Object)modifyResourceOperate.getDtoClass().getSimpleName(), (Object)this.manager.getResourceDefinition().getEntityClass().getSimpleName());
    }

    public void register(RemoveResourceOperate<ENTITY, ID> removeResourceOperate) {
        this.removeResourceOperate = removeResourceOperate;
        log.debug("register {} remove operate", (Object)this.manager.getResourceDefinition().getEntityClass().getSimpleName());
    }

    public void register(SearchResourceOperate<ENTITY, ID> searchResourceOperate) {
        this.searchResourceOperate = searchResourceOperate;
        log.debug("register {} search operate", (Object)this.manager.getResourceDefinition().getEntityClass().getSimpleName());
    }

    public AddResourceOperate<ENTITY, ?, ID> getAddResourceOperate(Class<?> dtoClass) {
        Class<?> temp = dtoClass;
        do {
            if (this.addResourceOperateMap == null || !this.addResourceOperateMap.containsKey(temp)) continue;
            return this.addResourceOperateMap.get(temp);
        } while ((temp = temp.getSuperclass()) != Object.class);
        throw new UnRegisterOperateException(this.manager.getClass(), "add", dtoClass);
    }

    public ModifyResourceOperate<ENTITY, ?, ID> getModifyResourceOperate(Class<?> dtoClass) {
        Class<?> temp = dtoClass;
        do {
            if (this.modifyResourceOperateMap == null || !this.modifyResourceOperateMap.containsKey(temp)) continue;
            return this.modifyResourceOperateMap.get(temp);
        } while ((temp = temp.getSuperclass()) != Object.class);
        throw new UnRegisterOperateException(this.manager.getClass(), "modify", dtoClass);
    }

    public RemoveResourceOperate<ENTITY, ID> getRemoveResourceOperate() {
        if (this.removeResourceOperate != null) {
            return this.removeResourceOperate;
        }
        throw new UnRegisterOperateException(this.manager.getClass(), "remove");
    }

    public SearchResourceOperate<ENTITY, ID> getSearchResourceOperate() {
        return this.searchResourceOperate;
    }

    public boolean isUniqueEntity() {
        return this.uniqueEntity;
    }
}

