/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.resource.operate;

import com.github.developframework.resource.AbstractResourceManager;
import com.github.developframework.resource.AddCheckExistsLogic;
import com.github.developframework.resource.BasicMapper;
import com.github.developframework.resource.DTO;
import com.github.developframework.resource.Entity;
import com.github.developframework.resource.exception.DTOCastException;
import com.github.developframework.resource.operate.AddResourceOperate;
import java.io.Serializable;
import java.util.Optional;

public abstract class AddUniqueResourceOperate<ENTITY extends Entity<ID>, DTO extends DTO, ID extends Serializable>
extends AddResourceOperate<ENTITY, DTO, ID> {
    private AddCheckExistsLogic<ENTITY, DTO, ID> logic;

    public AddUniqueResourceOperate(Class<DTO> dtoClass, Class<? extends BasicMapper<ENTITY, DTO>> mapperClass) {
        super(dtoClass, mapperClass);
    }

    @Override
    public void setManager(AbstractResourceManager<ENTITY, ID> manager) {
        super.setManager(manager);
        this.logic = this.configureCheckExistsLogic();
    }

    public abstract AddCheckExistsLogic<ENTITY, DTO, ID> configureCheckExistsLogic();

    @Override
    public Optional<ENTITY> addResource(Object obj) {
        if (this.dtoClass.isAssignableFrom(obj.getClass())) {
            DTO dto = (DTO)obj;
            if (this.before(dto)) {
                if (this.logic.check(dto)) {
                    throw this.logic.getResourceExistException(dto, this.resourceDefinition.getResourceName());
                }
                Object entity = this.create(dto);
                this.prepare(dto, entity);
                this.resourceHandler.insert(entity);
                this.after(dto, entity);
                return Optional.of(entity);
            }
            return Optional.empty();
        }
        throw new DTOCastException();
    }

    public AddCheckExistsLogic<ENTITY, DTO, ID> byField(String ... fields) {
        return this.manager.byFieldAddCheck(this.dtoClass, fields);
    }

    public AddCheckExistsLogic<ENTITY, DTO, ID> getLogic() {
        return this.logic;
    }
}

