/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.resource.operate;

import com.github.developframework.resource.AbstractResourceManager;
import com.github.developframework.resource.BasicMapper;
import com.github.developframework.resource.DTO;
import com.github.developframework.resource.Entity;
import com.github.developframework.resource.ModifyCheckExistsLogic;
import com.github.developframework.resource.exception.DTOCastException;
import com.github.developframework.resource.operate.ModifyResourceOperate;
import java.io.Serializable;
import java.util.Optional;

public abstract class ModifyUniqueResourceOperate<ENTITY extends Entity<ID>, DTO extends DTO, ID extends Serializable>
extends ModifyResourceOperate<ENTITY, DTO, ID> {
    private ModifyCheckExistsLogic<ENTITY, DTO, ID> logic;

    public ModifyUniqueResourceOperate(Class<DTO> dtoClass, Class<? extends BasicMapper<ENTITY, DTO>> mapperClass) {
        super(dtoClass, mapperClass);
    }

    @Override
    public void setManager(AbstractResourceManager<ENTITY, ID> manager) {
        super.setManager(manager);
        this.logic = this.configureCheckExistsLogic();
    }

    public abstract ModifyCheckExistsLogic<ENTITY, DTO, ID> configureCheckExistsLogic();

    @Override
    public Optional<ENTITY> modifyById(Object obj, ID id) {
        if (this.dtoClass.isAssignableFrom(obj.getClass())) {
            DTO dto = (DTO)obj;
            return this.resourceHandler.queryByIdForUpdate(id).map(entity -> {
                if (this.before(dto, entity)) {
                    if (this.logic.check(dto, (Entity)entity)) {
                        throw this.logic.getResourceExistException(dto, this.resourceDefinition.getResourceName());
                    }
                    this.merge(dto, entity);
                    this.prepare(dto, entity);
                    boolean success = this.resourceHandler.update(entity);
                    this.after(dto, entity);
                    return success ? entity : null;
                }
                return null;
            });
        }
        throw new DTOCastException();
    }

    public ModifyCheckExistsLogic<ENTITY, DTO, ID> byField(String ... fields) {
        return this.manager.byFieldModifyCheck(this.dtoClass, fields);
    }

    public ModifyCheckExistsLogic<ENTITY, DTO, ID> getLogic() {
        return this.logic;
    }
}

