/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.resource.utils;

import com.github.developframework.resource.exception.ResourceExistException;
import com.github.developframework.resource.exception.ResourceNotExistException;
import com.github.developframework.resource.utils.HasReturnResourceAssertBuilder;
import com.github.developframework.resource.utils.ResourceAssertBuilder;
import java.util.Objects;
import java.util.Optional;

public final class ResourceAssert {
    public static <T> T resourceExist(String resourceName, T resource) {
        if (Objects.nonNull(resource)) {
            return resource;
        }
        throw new ResourceNotExistException(resourceName);
    }

    public static <T> HasReturnResourceAssertBuilder<T> resourceExistAssertBuilder(String resourceName, T resource) {
        if (Objects.nonNull(resource)) {
            return new HasReturnResourceAssertBuilder<T>(resource);
        }
        return new HasReturnResourceAssertBuilder(new ResourceNotExistException(resourceName));
    }

    public static <T> T resourceExist(String resourceName, Optional<T> resourceOptional) {
        return resourceOptional.orElseThrow(() -> new ResourceNotExistException(resourceName));
    }

    public static <T> HasReturnResourceAssertBuilder<T> resourceExistAssertBuilder(String resourceName, Optional<T> resourceOptional) {
        return resourceOptional.map(HasReturnResourceAssertBuilder::new).orElseGet(() -> new HasReturnResourceAssertBuilder(new ResourceNotExistException(resourceName)));
    }

    public static void resourceNotExist(String resourceName, Object resource) {
        if (Objects.nonNull(resource)) {
            throw new ResourceExistException(resourceName);
        }
    }

    public static ResourceAssertBuilder resourceNotExistAssertBuilder(String resourceName, Object resource) {
        if (Objects.nonNull(resource)) {
            return new ResourceAssertBuilder(new ResourceExistException(resourceName));
        }
        return new ResourceAssertBuilder();
    }

    public static void resourceNotExist(String resourceName, Optional<Object> resourceOptional) {
        if (resourceOptional.isPresent()) {
            throw new ResourceExistException(resourceName);
        }
    }

    public static ResourceAssertBuilder resourceNotExistAssertBuilder(String resourceName, Optional<Object> resourceOptional) {
        if (resourceOptional.isPresent()) {
            return new ResourceAssertBuilder(new ResourceExistException(resourceName));
        }
        return new ResourceAssertBuilder();
    }
}

