/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.toolkit.base.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class Sorter<T> {
    private Map<Integer, Collection<T>> itemBox = new ConcurrentHashMap<Integer, Collection<T>>();
    private SortFunction<T> sortFunction;
    private int quantity;

    public Sorter(int quantity, SortFunction<T> sortFunction) {
        Objects.requireNonNull(sortFunction, "sortFunction not null.");
        this.quantity = quantity;
        for (int i = 1; i <= quantity; ++i) {
            this.itemBox.put(i, new LinkedList());
        }
        this.sortFunction = sortFunction;
    }

    private void postItem(int index, T item) {
        if (!this.itemBox.containsKey(index)) {
            throw new IllegalArgumentException("index is not exist: " + index);
        }
        this.itemBox.get(index).add(item);
    }

    public void sort(Collection<T> items) {
        if (this.sortFunction == null) {
            throw new IllegalStateException("sortFunction undefined.");
        }
        for (T item : items) {
            int index = this.sortFunction.sort(item);
            this.postItem(index, item);
        }
    }

    public List<T> openBox(int index) {
        if (this.itemBox.containsKey(index)) {
            return new ArrayList<T>(this.itemBox.get(index));
        }
        throw new IllegalArgumentException("index is not exist.");
    }

    public void clear() {
        for (int i = 0; i < this.quantity; ++i) {
            this.itemBox.get(i).clear();
        }
    }

    public int getQuantity() {
        return this.quantity;
    }

    @FunctionalInterface
    public static interface SortFunction<E> {
        public int sort(E var1);
    }
}

